/***********************************************************************/
/*                                                                     */
/*                               ACCESS PHASE                          */
/*                Copyright (C) 1992 Eric Charles Steinhart            */
/*                            All rights reserved.                     */
/*                                                                     */
/***********************************************************************/

#include "stdio.h"
#include "C:\qc25\include\graph.h"
#include "anadefs.h"
#include "semnet.h"
#include "buffer.h"
#include "iterate.h"

cons_ptr select_target_verbs( S, target, result)
struct SEMANTIC_NETWORK *S;     /* the semantic net */
cons_ptr target;                /* the target as a list of nodes */
cons_ptr result;                /* the resultant list of target verbs */
{
	cons_ptr t;
	int node;

/*  printf("IN select_target_verbs()\n");
	printf("target = "); print_node_names( target, S); printf("\n"); */

	t = target;
	while( not( null( t))) {
		node = car(t);
		if (GetType(S,node) == VERBTYPE)
			result = cons( node, result);
		t = cdr(t);  /* get next t */
		}
/*  printf("target verbs =");
	print_node_names( result, S); printf("\n"); */

	return( result);
}



/***************************************************************************/
/*                                                                         */
/*                       Find Candidate Source Fields                      */
/*                                                                         */
/***************************************************************************/
cons_ptr GenerateSourceNouns( S, target, source_nouns)
struct SEMANTIC_NETWORK *S;     /* the semantic network */
cons_ptr target;                /* the target field */
cons_ptr source_nouns;         /* the resultant source nouns */
{

	cons_ptr target_verbs;
	cons_ptr pframes;
	cons_ptr srcframes;
	cons_ptr t;
	int node;

	/* find the verbs in the target field */
	target_verbs = NIL;
	target_verbs = select_target_verbs( S, target, target_verbs);
/*  printf("The target verbs are:\n");
	printf("        "); print_node_names( target_verbs, S);*/

	/* propagate activation to frames in which */
	/* target verbs participate */
	pframes = NIL;
	pframes = state_trans( target_verbs, S, VERB,
					LITERAL, pframes);
	/* select only those frames which are not in the target */
	/* these are the frames in the candidate source fields */
	srcframes = NIL;
	t = pframes;
	while( not( null( t))) {
		node = car(t);
		if (not( is_member( node, target)))
			srcframes = cons( node, srcframes);
		t = cdr(t);  /* get next t */
		}

	/* find the nouns in the candidate source fields */
	source_nouns = nom_state_trans( srcframes, S, LITERAL,
				source_nouns);

	return( source_nouns);
}


/* SrcNounsToFuncSrcFields is used to compute candidate source fields from */
/* A2(TargetVerbs, LITERAL) - Target.  */
/* generate semantic fields from a list of nouns */
/* partition the list of nouns into densely interconnected clusters */
/* let each cluster generate a field */
sequence_ptr SrcNounsToFuncSrcFields( S, Zset, result)
struct SEMANTIC_NETWORK *S;     /* the semantic network */
cons_ptr Zset;                  /* the list of source nouns */
sequence_ptr result;            /* the resultant fields */
{
	sequence_ptr generators; /* clusters of nouns */
	sequence_ptr t;
	cons_ptr C;              /* a particular cluster */
	cons_ptr pframes, pterms, A2;
	cons_ptr ptr;
	int term, Zterm;
	sequence_ptr FieldsOfTerm, ExplicitFields, ImplicitFields;
	cons_ptr Zptr, remainder;

	/**********************************************************************/
	/*                  PROCESS EXPLICIT SEMANTIC FIELDS                  */
	/**********************************************************************/
	ExplicitFields = NIL;
	if (GetFields( S) != NIL) {
		/* then there are explicit fields */
		/* for each term x in Zset do */
		ListIterator( ptr, Zset) {
			term = car(ptr);
			if (not(TermInSequence(term, ExplicitFields))) {
				FieldsOfTerm = NIL;
				FieldsOfTerm = ExplicitFieldsOf(S, term, FieldsOfTerm);
				ExplicitFields = appendseq( ExplicitFields, FieldsOfTerm);
				}
			}
		/* see if there are any terms remaining in Zset */
		/* that are not in explicit fields */
		remainder = NIL;
		ListIterator( Zptr, Zset) {
			term = car(Zptr);
			if (not(TermInSequence(term, ExplicitFields)))
				remainder = cons(term, remainder);
			}

		/* if there are no terms in Zset that are not in explicit fields */
		/* then all terms in Zset are in explicit fields */
		/*      so set result = ExplicitFields and return */
		/* else it is necessary to use regular field generation methods */
		/*      for the remaining terms in Zset */
		if (null(remainder)) {
			result = ExplicitFields;
			return( result);
			}
		else Zset = remainder;
		}

	/**********************************************************************/
	/*                  PROCESS IMPLICIT SEMANTIC FIELDS                  */
	/**********************************************************************/
	ImplicitFields = NIL;

	/* find the set of clusters in Z(n) */
	generators = NIL;
	generators = partitions( S, Zset, generators);

	/* for every cluster C in partitions(Z(n)) */
	t = generators;
	while( not( nullseq( t))) {
		C = carseq( t);
		/* find the field generated by C */
		/* find the participating frames */
		pframes = NIL;
		pframes = gen_state_trans(C, S, LITERAL, pframes);
		/* find the participating terms */
		pterms = NIL;
		pterms = gen_state_trans(pframes, S, LITERAL, pterms);
		/* func field is the union of pframes & pterms */
		A2 = NIL;
		A2 = list_union( pframes, pterms);
		/* form the paradigmatic closure of the source field */
		A2 = ParadigmaticClosure( S, A2);
		ImplicitFields = unionseq( nconseq( A2), ImplicitFields);
		t = cdrseq( t); /* get next cluster */
		}

	/* combine explicit and implicit fields and return */
	result = appendseq( ImplicitFields, ExplicitFields);
	return( result);
}

int source_fields_menu( target_type)
int target_type;
{

	int option;
	int source_type;

	_clearscreen( _GCLEARSCREEN);
	DisplayWindow( SourceMenuWindow);
	DisplayWindow( ErrorWindow);

	switch (target_type) {
		case 1:
			posprint( 7,15, "Targets are functional fields");
			posprint( 8,15, "     with no mereological closure.");
			posprint(10,15, "Source fields are functional fields with");
			posprint(11,15, "NO mereological closure.");
			source_type = FUNC_NO_CLOSURE;
			break;
		case 2:
			posprint( 7, 15, "Targets are functional fields");
			posprint( 8, 15, "     with mereological closure");
			posprint( 9, 15, "     by method of least maximal wholes.");
			posprint(11, 15, "Source fields can be functional fields with");
			posprint(12, 15, "mereological closure");
			posprint(13, 15, "     by method of least maximal whole: 1");
			posprint(14, 15, "     by method of maximal whole:       2");
			option = get_option( SourceMenuWindow);
			if (option == 1)
				source_type = FUNC_LEAST_MAX_CLOSURE;
			else source_type = FUNC_MAX_CLOSURE;
			break;
		case 3:
			posprint( 7, 15, "Targets are functional fields");
			posprint( 8, 15, "     with mereological closure");
			posprint( 9, 15, "     by method of least maximal wholes.");
			posprint(11, 15, "Source fields can be functional fields with");
			posprint(12, 15, "mereological closure");
			posprint(13, 15, "     by method of least maximal whole: 1");
			posprint(14, 15, "     by method of maximal whole:       2");
			option = get_option( SourceMenuWindow);
			if (option == 1)
				source_type = FUNC_LEAST_MAX_CLOSURE;
			else source_type = FUNC_MAX_CLOSURE;
			break;
		case 4:
			posprint( 7, 15, "Targets are structural fields");
			posprint( 9, 15, "Source fields can be structural fields with");
			posprint(10, 15, "mereological closure");
			posprint(11, 15, "     by method of least maximal whole: 1");
			posprint(12, 15, "     by method of maximal whole:       2");
			option = get_option( SourceMenuWindow);
			if (option == 1)
				source_type = STRUCT_LEAST_MAX_CLOSURE;
			else source_type = STRUCT_MAX_CLOSURE;
			break;
	    default:
			printf("ERROR: Unexpected target field type.\n");
			exit(ERROR_VALUE);
	    }
	return( source_type);
}

sequence_ptr CloseSourceFields( S, SourceFields, ClosureMethod)
struct SEMANTIC_NETWORK *S;
sequence_ptr SourceFields;
int ClosureMethod;
{
	sequence_ptr F;
	sequence_ptr ClosedSrcFields;
	cons_ptr this_field;

/*  printf("ENTER: CloseSourceFields\n");*/

	/* for each field F in SourceFields, mereologically close F */
	ClosedSrcFields = NIL;
	F = SourceFields;
	while( not (nullseq( F))) {
		this_field = carseq( F);
		this_field = MereologicalClosure(
					S, this_field, ClosureMethod);
		ClosedSrcFields = conseq( this_field, ClosedSrcFields);
		F = cdrseq( F);
		}
/*      printf("EXIT: CloseSourceFields\n");*/

	return( ClosedSrcFields);
}

sequence_ptr gen_cand_srcs( S, target, target_type, SourceFields)
struct SEMANTIC_NETWORK *S;
cons_ptr target;
int target_type;
sequence_ptr SourceFields;
{
	int source_type;
	cons_ptr SourceNouns;

/*      printf("ENTER: gen_cand_srcs\n");*/

	/* get the type of source field to be generated */
	source_type = source_fields_menu( target_type);

	switch (source_type) {
	   case FUNC_NO_CLOSURE:
		SourceNouns = NIL;
		SourceNouns = GenerateSourceNouns(S, target, SourceNouns);
		SourceFields = SrcNounsToFuncSrcFields(
					S, SourceNouns, SourceFields);
		break;
	   case FUNC_LEAST_MAX_CLOSURE:
		SourceNouns = NIL;
		SourceNouns = GenerateSourceNouns(S, target, SourceNouns);
		SourceFields = SrcNounsToFuncSrcFields(
					S, SourceNouns, SourceFields);
		/* for each F in SourceFields, do */
		/*     close F by method of least max wholes */
		SourceFields = CloseSourceFields( S, SourceFields,
					LEAST_MAX_WHOLES_METHOD);
		break;
	   case FUNC_MAX_CLOSURE:
		SourceNouns = NIL;
		SourceNouns = GenerateSourceNouns(S, target, SourceNouns);
		SourceFields = SrcNounsToFuncSrcFields(
					S, SourceNouns, SourceFields);
		/* for each F in SourceFields, do */
		/*      close F by method of maximal wholes */
		SourceFields = CloseSourceFields( S, SourceFields,
					MAX_WHOLES_METHOD);
		break;
	   case STRUCT_LEAST_MAX_CLOSURE:
		SourceNouns = NIL;
		SourceNouns = GenerateSourceNouns(S, target, SourceNouns);
		/* compute the mereological closure of SourceNouns   */
		/* using method of least maximal wholes              */
		SourceNouns = MereologicalClosure( S, SourceNouns,
					     LEAST_MAX_WHOLES_METHOD);
		SourceFields = GrowStructFieldFromNouns(
					S, SourceNouns, SourceFields);
		break;
	   case STRUCT_MAX_CLOSURE:
		SourceNouns = NIL;
		SourceNouns = GenerateSourceNouns(S, target, SourceNouns);
		/* compute the mereological closure of SourceNouns   */
		/* using method of least maximal wholes              */
		SourceNouns = MereologicalClosure( S, SourceNouns,
					     MAX_WHOLES_METHOD);
		SourceFields = GrowStructFieldFromNouns(
					S, SourceNouns, SourceFields);
		break;
	   default:
		printf("ERROR:Unknown type of source field.\n");
		exit(ERROR_VALUE);
		break;
	   } /* end switch source_type */
/*      printf("EXIT: gen_cand_srcs\n");*/

	return( SourceFields);
}

/***************************************************************************/
/*                                                                         */
/*                            Access Phase Function                        */
/*                                                                         */
/***************************************************************************/
/* The access phase function:                   */
/*      1. asks the user for a cue,             */
/*      2. generates a target,                  */
/*      3. generates candidate source domains.  */
void access_phase( S)
struct SEMANTIC_NETWORK *S;
{
	int need_target, ThereIsAnError, target_cue, target_type;
	char ErrorMsg[80];
	sequence_ptr FieldsOfCue;
	cons_ptr target_field;  /* the target field */
	sequence_ptr cand_srcs; /* the candidate source fields */
	sequence_ptr SrcsPtr;
	struct TextBuffer *FB;

	/* generate the target field */
	need_target = TRUE;
	ThereIsAnError = FALSE;
	while( need_target) {
		_clearscreen( _GCLEARSCREEN);
		DisplayTermsInNetwork( S, TermsWindow);
		DisplayWindow( TopicNodeQueryWindow);
		DisplayWindow( ErrorWindow);
		if (ThereIsAnError) PrintError( ErrorMsg);
		/* get the target cue */
		target_cue = query_user_for_node(S, TopicNodeQueryWindow);
		_clearscreen( _GCLEARSCREEN);
		/* generate target field from the cue */
		target_type = fields_type_menu( S, target_cue);
		FieldsOfCue = NIL;
		FieldsOfCue = get_fields( S, target_cue, target_type, FieldsOfCue);
		target_field = carseq( FieldsOfCue);
		if (null( target_field)) {
			ThereIsAnError = TRUE;
			sprintf(ErrorMsg, "Target field for <%s> was NIL.",
					GetName(S,target_cue));
			}
		else need_target = FALSE;
		}

	/* generate candidate source fields */
	cand_srcs = NIL;
	cand_srcs = gen_cand_srcs( S, target_field, target_type, cand_srcs);

	/* print the candidate source fields */
	FB = AllocateTextBuffer();
	InitializeTextBuffer( FB);
	StringMove( FB, "-------- Please Scroll Down -------");
	NextLine(FB);
	StringMove( FB, "The source fields are: ");
	NextLine(FB);
	FillFieldBuffer( S, FB, cand_srcs);
	StringMove( FB, "***** End of Text *****");
	NextLine(FB);
	DisplayBuffer( FB, FieldScrollWindow);
	free( FB);
}
