/***********************************************************************/
/*                                                                     */
/*                                DEFINITIONS                          */
/*                Copyright (C) 1992 Eric Charles Steinhart            */
/*                            All rights reserved.                     */
/*                                                                     */
/***********************************************************************/

/* Definitions. */
#define TRUE 1
#define FALSE 0
#define NIL 0
#define not(x) (!(x))

#define YES 1
#define NO 0

/* There has to be a special NIL code for nodes, since */
/* there is a zero-th node */
#define NO_WHOLE -1

#define NO_FILLER -1

/* Error code for exit() */
#define ERROR_VALUE 1

/* the maximum string length is MAX_STRLEN characters */
#define MAX_STRLEN 15

#define MAX_SURFACE_POSITIONS 4

#define NUM_EXERCISE_FILES  8 /* the number of exercise files */

/* The ClosureMethod determines how the mereological closure of a */
/* semantic field is computed in fields.c */
#define LEAST_MAX_WHOLES_METHOD 1
#define MAX_WHOLES_METHOD       2


/***************************************************************************/
/*                            LISTS & SEQUENCES                            */
/***************************************************************************/
typedef int cons_data;

/* define a cons_cell whose data is a node */
struct cons_cell {
	cons_data cell_data;
	struct cons_cell *next;
	};
typedef struct cons_cell *cons_ptr;

/* define a sequence_cell whose data is a cons_ptr */
struct sequence_cell {
	cons_ptr cell_data;
	struct sequence_cell *next;
	};
typedef struct sequence_cell *sequence_ptr;


/***************************************************************************/
/***************************************************************************/

#define COMMA           ','
#define OPEN_PAREN      '('
#define CLOSE_PAREN     ')'
#define UPARROW         72
#define DOWNARROW       80
#define ESCAPE          27
#define ENTER           13

#define SCREEN_LENGTH   25

#define FUNC_NO_CLOSURE                 1
#define FUNC_LEAST_MAX_CLOSURE          2
#define FUNC_MAX_CLOSURE                3
#define STRUCT_LEAST_MAX_CLOSURE        4
#define STRUCT_MAX_CLOSURE              5

#define STR_NOT_FOUND_ERROR -1

#define MAIN_MENU_OPTIONS 2


/***************************************************************************/
/*                            WINDOWS & BUFFERS                            */
/***************************************************************************/

#define NUM_CURSOR_POSITIONS 3
#define QueryMessage    0   /* Cursor Row/Col For[QueryMessage] */
#define UserResponse    1   /* Cursor Row/Col For[UserResponse] */
#define ExtraMessage    2   /* Cursor Row/Col For[ExtraMessage] */
struct WindowStruct {
	int StartCol;
	int StartRow;
	int EndCol;
	int EndRow;
	int CursorRowFor[NUM_CURSOR_POSITIONS];
	int CursorColFor[NUM_CURSOR_POSITIONS];
	int MenuMin;
	int MenuMax;
	void (*Initializer)();
	};


#define NO_CURSOR 0x2000
#define STANDARD_CURSOR 0x0707

struct WindowStruct *FrameScrollWindow;
struct WindowStruct *InferenceScrollWindow;
struct WindowStruct *TransferenceScrollWindow;
struct WindowStruct *LogicScrollWindow;
struct WindowStruct *PropNodeQueryWindow;
struct WindowStruct *FileNamesWindow;
struct WindowStruct *MessageWindow;
struct WindowStruct *WordsWindow;
struct WindowStruct *TermsWindow;
struct WindowStruct *HypoNetWindow;
struct WindowStruct *FieldWindow;
struct WindowStruct *FrameNodeQueryWindow;
struct WindowStruct *FieldNodeQueryWindow;
struct WindowStruct *TopicNodeQueryWindow;
struct WindowStruct *SourceNodeQueryWindow;
struct WindowStruct *SourceMenuWindow;
struct WindowStruct *FieldScrollWindow;
struct WindowStruct *FieldChoiceWindow;
struct WindowStruct *AnalogyScrollWindow;
struct WindowStruct *HypoScrollWindow;
struct WindowStruct *ActivationsWindow;
struct WindowStruct *StartMetsWindow;
struct WindowStruct *MetaphorWindow;
struct WindowStruct *ErrorWindow;


/***************************  INTERFACE FUNCTIONS ***********************/
void rectangle(
	int start_col,
	int start_row,
	int end_col,
	int end_row);

/* void posprint(); */

void DisplayWindow(
	struct WindowStruct *Window);

void DisplayExtraMsg(
	struct WindowStruct *Window,
	char *Msg);

void GetConsoleFileName( char *string, int nchars);

/************************** LIST & SEQUENCE PROCESSING ******************/
cons_ptr cons( cons_data this_data, cons_ptr list);

cons_ptr ncons( cons_data this_data);

int null( cons_ptr list);

cons_data car( cons_ptr list);

cons_data first( cons_ptr list);

cons_ptr cdr( cons_ptr list);

int second( cons_ptr list);

cons_ptr last( cons_ptr list);

int is_member( cons_data this_data, cons_ptr list);

int is_subset( cons_ptr list1, cons_ptr list2);

int length( cons_ptr list);

cons_ptr setdiff( cons_ptr list1, cons_ptr list2, cons_ptr result);

cons_ptr intersect( cons_ptr list1, cons_ptr list2, cons_ptr result);

cons_ptr list_union( cons_ptr list1, cons_ptr list2);

cons_ptr list_append( cons_ptr list1, int item);

int equal( cons_ptr list1, cons_ptr list2);

int print_list( cons_ptr list);

void FreeList( cons_ptr list);

int print_node_names( cons_ptr list, struct SEMANTIC_NETWORK *S);

int print_node_names_NOCR( cons_ptr list, struct SEMANTIC_NETWORK *S);

sequence_ptr conseq( cons_ptr this_list, sequence_ptr sequence);

sequence_ptr nconseq( cons_ptr this_list);

int nullseq( sequence_ptr sequence);

cons_ptr carseq( sequence_ptr sequence);

cons_ptr firstseq( sequence_ptr sequence);

sequence_ptr cdrseq( sequence_ptr sequence);

sequence_ptr lastseq( sequence_ptr sequence);

sequence_ptr appendseq( sequence_ptr sequence1, sequence_ptr sequence2);

int is_memberseq( cons_ptr list, sequence_ptr sequence);

int lengthseq( sequence_ptr sequence);

sequence_ptr unionseq( sequence_ptr sequence1, sequence_ptr sequence2);

void print_sequence( sequence_ptr sequence);

void print_sequence_names(
	sequence_ptr sequence,
	struct SEMANTIC_NETWORK *sem_net);

int get_positionseq( cons_ptr element, sequence_ptr sequence);

cons_ptr get_nth_seq( sequence_ptr seq, int n);

void FreeSequence( sequence_ptr sequence);


/*********************** TRANSIT FUNCTION HEADERS *********************/
cons_ptr gen_node_trans(
	int origin,
	struct SEMANTIC_NETWORK *S,
	int sm,
	cons_ptr to);

cons_ptr node_trans(
	int origin,
	struct SEMANTIC_NETWORK *S,
	int tr,
	int sm,
	cons_ptr to);

cons_ptr nom_node_trans(
	int origin,
	struct SEMANTIC_NETWORK *S,
	int sm,
	cons_ptr to);

cons_ptr para_node_trans(
	int origin,
	struct SEMANTIC_NETWORK *S,
	int sm,
	cons_ptr to);

cons_ptr gen_state_trans(
	cons_ptr state,
	struct SEMANTIC_NETWORK *S,
	int sm,
	cons_ptr to);

cons_ptr state_trans(
	cons_ptr state,
	struct SEMANTIC_NETWORK *S,
	int tr,
	int sm,
	cons_ptr to);

cons_ptr nom_state_trans(
	cons_ptr state,
	struct SEMANTIC_NETWORK *S,
	int sm,
	cons_ptr to);

int WholeOf(
	struct SEMANTIC_NETWORK *S,
	int x);

int MaximalWholeOf(
	struct SEMANTIC_NETWORK *S,
	int x);

cons_ptr MereologicalChain(
	struct SEMANTIC_NETWORK *S,
	int x,
	cons_ptr result);

cons_ptr AllPartsOf(
	struct SEMANTIC_NETWORK *S,
	int x,
	cons_ptr result);

int GetFrameAdjective(
	struct SEMANTIC_NETWORK *S,
	int FrameId,
	int Position);

int GetFrameModifier(
	struct SEMANTIC_NETWORK *S,
	int FrameId,
	int Position);

int GetFrameNoun(
	struct SEMANTIC_NETWORK *S,
	int FrameId,
	int Position);


int GetFrameVerb(
	struct SEMANTIC_NETWORK *S,
	int FrameId);

int GetFrameHead(
	struct SEMANTIC_NETWORK *S,
	int FrameId,
	int Position);

int GetRolePosition(
	struct SEMANTIC_NETWORK *S,
	int FrameId,
	int Position);

int GetPositiveTerm(
	struct SEMANTIC_NETWORK *S,
	int FrameId);

int GetNegativeTerm(
	struct SEMANTIC_NETWORK *S,
	int FrameId);

int GetAntecedent(
	struct SEMANTIC_NETWORK *S,
	int FrameId);

int GetConsequent(
	struct SEMANTIC_NETWORK *S,
	int FrameId);

int GetAttributeTerm(
	struct SEMANTIC_NETWORK *S,
	int FrameId);

int GetObjectTerm(
	struct SEMANTIC_NETWORK *S,
	int FrameId);

cons_ptr GetLiteralValues(
	struct SEMANTIC_NETWORK *S,
	int FrameId,
	cons_ptr Values);

cons_ptr GetAnalogicalValues(
	struct SEMANTIC_NETWORK *S,
	int FrameId,
	cons_ptr Values);

cons_ptr GetAllConsequentFrames(
	struct SEMANTIC_NETWORK *S,
	int FrameId,
	cons_ptr AllConsequents);

cons_ptr GetFeatures(
	struct SEMANTIC_NETWORK *S,
	int Noun,
	int Mode,
	cons_ptr TheFeatures);

cons_ptr GetPredicableAdjectives(
	struct SEMANTIC_NETWORK *S,
	int Noun,
	cons_ptr AdjectivesOfNoun);

/*************************** SEM FIELD FUNCTION HEADERS ******************/
sequence_ptr partitions(
	struct SEMANTIC_NETWORK *S,
	cons_ptr Zset,
	sequence_ptr result);

cons_ptr ParadigmaticClosure(
	struct SEMANTIC_NETWORK *S,
	cons_ptr field);

cons_ptr MereologicalClosure(
	struct SEMANTIC_NETWORK *S,
	cons_ptr F,
	int ClosureMethod);

sequence_ptr GrowStructFieldFromNouns(
	struct SEMANTIC_NETWORK *S,
	cons_ptr FieldNouns,
	sequence_ptr Field);

sequence_ptr ExplicitFieldsOf(
	struct SEMANTIC_NETWORK *S,
	int term,
	sequence_ptr result);

sequence_ptr get_fields(
	struct SEMANTIC_NETWORK *S,
	int x,
	int fields_type,
	sequence_ptr FieldsOfCue);

cons_ptr find_one_field(
	struct SEMANTIC_NETWORK *S,
	int cue,
	cons_ptr result);

cons_ptr select_target_verbs(
	struct SEMANTIC_NETWORK *S,
	cons_ptr target,
	cons_ptr result);

char *StrMove( char *s, char *t);

sequence_ptr gen_cand_srcs(
	struct SEMANTIC_NETWORK *S,
	cons_ptr target,
	int target_type,
	sequence_ptr SourceFields);

struct map_structure *make_map_from_net(
	struct SEMANTIC_NETWORK *S,
	struct map_structure *map,
	cons_ptr target,
	cons_ptr source);

struct SEMANTIC_NETWORK *initialize_the_net(
	struct SEMANTIC_NETWORK *S);

struct SEMANTIC_NETWORK *elaborate(
	struct SEMANTIC_NETWORK *S,
	int topic_node,
	int source_node);

cons_ptr select_one_field(
	sequence_ptr candidates,
	cons_ptr result,
	struct WindowStruct *Window);

cons_ptr GetTransferredTopicFrames(
	struct map_structure *map,
	cons_ptr result);

struct SEMANTIC_NETWORK *AnalogicalTransference(
	struct SEMANTIC_NETWORK *S,
	struct map_structure *map,
	cons_ptr topic,
	cons_ptr source);

