/***********************************************************************/
/*                                                                     */
/*                             SCROLLING BUFFERS                       */
/*                Copyright (C) 1993 Eric Charles Steinhart            */
/*                            All rights reserved.                     */
/*                                                                     */
/***********************************************************************/
#include "C:\qc25\include\conio.h"
#include "C:\qc25\include\graph.h"
#include "C:\qc25\include\stdlib.h"
#include "anadefs.h"

#define CARRIAGE_RETURN     13

/* coordinates for restricted screen inside buffer window */
#define UPPER_LEFT_ROW      1
#define UPPER_LEFT_COL      1
#define LOWER_RIGHT_ROW     25
#define LOWER_RIGHT_COL     79

#define BUFF_MAX        256
#define LINE_LENGTH     80
struct TextBuffer {
	char Lines[BUFF_MAX][LINE_LENGTH]; /* the text buffer */
	int LineMax;                       /* number of lines in buffer */
	char *LinePtr;                     /* character position in buffer */
	int top;                           /* top line displayed */
	int bottom;                        /* bottom line displayed */
	};

struct TextBuffer *AllocateTextBuffer( void)
{
	return( (struct TextBuffer *)
				malloc( (size_t) sizeof( struct TextBuffer)));
}


void InitializeTextBuffer( FB)
struct TextBuffer *FB;
{
	int i;

	for (i=0; i < BUFF_MAX; i++) FB->Lines[i][0] = 0;
	FB->LineMax = 0;
	FB->LinePtr = FB->Lines[0];
}


void StringMove( BP, t)
struct TextBuffer *BP;
char *t;
{
	while ((*(BP->LinePtr) = *t) != '\0') {
		(BP->LinePtr)++;
		t++;
		}
}

char *CurrentLine( FB)
struct TextBuffer *FB;
{
	return( FB->Lines[FB->LineMax]);
}

void NextLine( BP)
struct TextBuffer *BP;
{
	BP->LineMax++;
	if (BP->LineMax > BUFF_MAX) {
		printf("ERROR: Too many lines for buffer.\n");
		exit( ERROR_VALUE);
		}
	BP->LinePtr = BP->Lines[BP->LineMax];
}

void BackUpOneLine( BP)
struct TextBuffer *BP;
{
	BP->LineMax--;
}

void display( BP, Window)
struct TextBuffer *BP;
struct WindowStruct *Window;
{
	int i, j, ch, BeyondEnd, TheEnd;

	TheEnd = Window->EndCol - Window->StartCol - 2;
	for (i = 0; ((i <= BP->bottom) && (i <= BP->LineMax)); i++) {
		BeyondEnd = FALSE;
		_settextposition( i+1, 2);
		for (j = 0; j < TheEnd; j++) {
			ch = BP->Lines[i][j];
			if ((ch == '\n') || (ch == '\0')) BeyondEnd = TRUE;
			if (BeyondEnd) putch(' ');
			else putch( BP->Lines[i][j]);
			}
		}
}

void forward( BP, Window)
struct TextBuffer *BP;
struct WindowStruct *Window;
{
	int j, TheEnd, BeyondEnd;
	char ch;

	TheEnd = Window->EndCol - Window->StartCol - 2;
	if (BP->bottom < BP->LineMax) {
		BP->top++;
		BP->bottom++;
		_scrolltextwindow( _GSCROLLUP);
		_settextposition(Window->EndRow, 2);
		BeyondEnd = FALSE;
		for (j = 0; j < TheEnd; j++) {
			ch = BP->Lines[BP->bottom][j];
			if ((ch == '\n') || (ch == '\0')) BeyondEnd = TRUE;
			if (BeyondEnd) putch(' ');
			else putch( BP->Lines[BP->bottom][j]);
			}
		}
}

void backward( BP, Window)
struct TextBuffer *BP;
struct WindowStruct *Window;
{
	int j, BeyondEnd, TheEnd;
	char ch;

	TheEnd = Window->EndCol - Window->StartCol - 2;
	if (BP->top > 0) {
		BP->top--;
		BP->bottom--;
		_scrolltextwindow( _GSCROLLDOWN);
		_settextposition(Window->StartRow, 2);
		BeyondEnd = FALSE;
		for (j = 0; j < TheEnd; j++) {
			ch = BP->Lines[BP->top][j];
			if ((ch == '\n') || (ch == '\0')) BeyondEnd = TRUE;
			if (BeyondEnd) putch(' ');
			else putch( BP->Lines[BP->top][j]);
			}
		}
}

void DisplayBuffer( BP, Window)
struct TextBuffer *BP;
struct WindowStruct *Window;
{
	char answer;
	int done, i;

	/* initialize the screen */
	_clearscreen( _GCLEARSCREEN);
	BP->top = 0;
	BP->bottom = Window->EndRow - Window->StartRow - 2;
/*  printf("Top is <%d>; Bottom is <%d>", BP->top, BP->bottom);
	strike_any_key();*/
	DisplayWindow( Window);

	_settextwindow( Window->StartRow + 1,  Window->StartCol + 1,
					Window->EndRow - 1, Window->EndCol - 1);
	display( BP, Window);

	done = FALSE;
	while( not( done)) {
		answer = getch();
		switch (answer) {
			case UPARROW:
				backward( BP, Window);
				break;
			case DOWNARROW:
				forward( BP, Window);
				break;
			case ENTER:
				done = TRUE;
				break;
			case ESCAPE:
				_settextwindow(0,0,25,80);
				_clearscreen( _GCLEARSCREEN);
				_settextcursor( STANDARD_CURSOR);
				printf("Exiting SFTM implementation.\n");
				exit(0);
				break;
			default: continue;
			}
		} /* end while not done */

	/* restore the screen to original size */
	_settextwindow(0,0,25,80);

}

