void *DumpSemNet( S)
struct SEMANTIC_NETWORK *S;
{
	int i, j, AllNamesNil, AllConnNil;
	int AllRolesNil, AllModesNil, AllModesLiteral, AllTypesNil;

	printf("Number of nodes = <%d>\n", S->num_nodes);

	AllNamesNil = TRUE;
	for (i = 0; i < MAX_NODES; i++)
		if (S->node_names[i][0] != (char) 0) AllNamesNil = FALSE;
	printf("All node names are %s nil.\n", AllNamesNil?"":"NOT");

	printf("Number of connections = <%d>\n", S->num_connections);

	AllConnNil = TRUE;
	for (i = 0; i < MAX_NODES; i++)
		for (j = 0; j < MAX_NODES; j++)
			if (GetConn(S, i, j) != 0) AllConnNil = FALSE;
	printf("All connections are %s nil.\n", AllConnNil?"":"NOT");

	AllRolesNil = TRUE;
	for (i = 0; i < MAX_CONNECTIONS; i++)
		if (S->role[i] != 0) AllRolesNil = FALSE;
	printf("All roles are %s nil.\n", AllRolesNil?"":"NOT");

	AllModesNil = TRUE;
	for (i = 0; i < MAX_CONNECTIONS; i++)
		if (S->mode[i] != 0) AllModesNil = FALSE;
	printf("All roles are %s nil.\n", AllModesNil?"":"NOT");

	AllModesLiteral = TRUE;
	for (i = 0; i < MAX_CONNECTIONS; i++)
		if (S->mode[i] != LITERAL) AllModesLiteral = FALSE;
	printf("All roles are %s literal.\n", AllModesLiteral?"":"NOT");

	AllTypesNil = TRUE;
	for (i = 0; i < MAX_NODES; i++)
		if (S->node_type[i] != 0) AllTypesNil = FALSE;
	printf("All types are %s nil.\n", AllTypesNil?"":"NOT");

	if (S->fields == NIL)
		printf("Fields are nil.\n");
	else printf("Fields are NOT nil.\n");

	strike_any_key();
}


/***********************************************************************/
/*                    Printing the Frames in the Network               */
/***********************************************************************/
void print_syntagmatic_frame( S, FrameId)
struct SEMANTIC_NETWORK *S;
int FrameId;
{
	int position;
	int Modifier, Head, Role;
	char temp[MAX_STRLEN];

	/****************************************************************/
	/*                                                              */
	/* Surface Grammar in NETMET is basically:                      */
	/*      Position1: [MOD1] NOUN1                                 */
	/*      Position2: [ADVERB] VERB                                */
	/*      Position3: [PREP2] [MOD2] NOUN2                         */
	/*      Position4: [PREP3 [MOD3] NOUN3]                         */
	/*                                                              */
	/* Current default grammatical forms in NETMET:                 */
	/*  AGENT VERB PATIENT                                          */
	/*      student expresses idea                                  */
	/*  AGENT VERB PREP PATIENT                                     */
	/*      mother gives birth to baby                              */
	/*  AGENT VERB PATIENT with INSTRUMENT                          */
	/*      student expresses idea with mouth                       */
	/*  AGENT VERB PREP PATIENT with INSTRUMENT                     */
	/*      mother gives birth to baby with vagina                  */
	/*  SOURCE VERB PATIENT to RECIPIENT                            */
	/*      perception delivers images to memory                    */
	/*  RECIPIENT VERB PATIENT from SOURCE                          */
	/*      memory receives images from perception                  */
	/*                                                              */
	/****************************************************************/

	printf("%s: ", GetName(S, FrameId));
	IntegerIterator(position, 1, MAX_SURFACE_POSITIONS) {
		Modifier = GetModifierAtPosition(S, FrameId, position);
		if (Modifier != NO_FILLER)
			printf("%s ", GetName(S,Modifier));
		Head = GetHeadAtPosition(S, FrameId, position);
		if (Head != NO_FILLER) {
			if (position == 3) {
				Role = GetRoleOfPosition(S, FrameId, position);
				if (Role >= FIRST_PREPOSITION) {
					strcpy(temp, role_names[Role]);
					printf("%s ", strlwr( temp));
					}
				}
			if (position == 4) {
				/* print relevant preposition for fourth case slot */
				Role = GetRoleOfPosition(S, FrameId, position);
				switch( Role) {
					case SOURCE: printf("from "); break;
					case RECIPIENT: printf("to "); break;
					case INSTRUMENT: printf("with "); break;
					default: printf( "%s ", role_names[Role]);
					}
				}
			printf("%s ", GetName(S,Head));
			}
		}
	printf("\n");
}

void print_paradigmatic_frame(S, FrameId)
struct SEMANTIC_NETWORK *S;
int FrameId;
{
	int PosTerm, NegTerm;

	PosTerm = GetPositiveTerm(S, FrameId);
	NegTerm = GetNegativeTerm(S, FrameId);

	if ((PosTerm == NO_FILLER) && (NegTerm != NO_FILLER))
		printf("'%s'is the opposite of '%s'\n",
			GetName(S,PosTerm),
			GetName(S,NegTerm));
}

void print_parts( S, the_node)
struct SEMANTIC_NETWORK *S;
int the_node;
{
	cons_ptr t, the_parts;

	/* print any MEREOLOGICAL frames in which the node is a WHOLE */
	the_parts = NIL;
	the_parts = node_trans( the_node, S, WHOLE, LITERAL, the_parts);
	ListIterator( t, the_parts) {
		printf("%s contains %s\n",
			GetName(S,the_node), GetName(S, car(t)));
		}
}

void print_many_frames( S, the_frames)
struct SEMANTIC_NETWORK *S;
cons_ptr the_frames;
{
	cons_ptr t;

	/* print each frame in the_frames */
	t = the_frames;
	while( not( null( t))) {
		print_syntagmatic_frame( S, car(t));
		t = cdr(t); /* get next t */
		}
}

void print_network_frames( S)
struct SEMANTIC_NETWORK *S;
{
	int i, j;
	int this_node;

	/* for each node in the semantic network */
	IntegerIterator( i, 0, GetNumNodes( S)) {
		switch (GetType(S,i)) {
			case SFRAME: print_syntagmatic_frame( S, i);
						 break;
			case PFRAME: print_paradigmatic_frame( S, i);
						 break;
			case NOUN:   print_parts( S, i);
						 break;
			}
		} /* end of for each node */
}


void ConjunctionToBuffer( S, FB, FrameId)
struct SEMANTIC_NETWORK *S;   /* the semantic network */
struct TextBuffer *FB;
int FrameId;                  /* the conjunction node */
{
	cons_ptr LitBranches, AnaBranches, ptr;
	int ThisBranch;
	char *LinePtr;

	/* get all the LITERAL ANDBRANCHes of the conjunction node */
	LitBranches = NIL;
	LitBranches = node_trans( FrameId, S, ANDBRANCH, LITERAL, LitBranches);

	/* get all the LITERAL ANDBRANCHes of the conjunction node */
	AnaBranches = NIL;
	AnaBranches = node_trans( FrameId, S, ANDBRANCH, ANALOGICAL, AnaBranches);

	/* print all the ANDBRANCHes to the buffer */
	LinePtr = CurrentLine( FB);
	LinePtr = StrMove(LinePtr, GetName(S,FrameId));
	LinePtr = StrMove(LinePtr, ": and(");
	ListIterator( ptr, LitBranches) {
		ThisBranch = car(ptr);
		LinePtr = StrMove(LinePtr, GetName(S,ThisBranch));
		if (not(null(cdr(ptr)) && null(AnaBranches)))
			LinePtr = StrMove(LinePtr, ", ");
		}
	ListIterator( ptr, AnaBranches) {
		ThisBranch = car(ptr);
		LinePtr = StrMove(LinePtr, "[");
		LinePtr = StrMove(LinePtr, GetName(S,ThisBranch));
		LinePtr = StrMove(LinePtr, "]");
		LinePtr = StrMove(LinePtr, (null(cdr(ptr)))?"":", ");
		}
	LinePtr = StrMove(LinePtr, ")");
	FB->LineMax++;
}

void PrintComplexToScreen( S, root)
struct SEMANTIC_NETWORK *S;
struct LogicNode *root;
{
	int i;
	struct LogicStack *stack;

	if (root == NIL) return;

	for (i=0; root->PrettyPrint[i] != NO_FILLER; i++) {
		if (root->PrettyPrint[i] == PRINT_MARK) {
			if (root->PrettyPrint[i+1] == NO_FILLER)
			   printf("|===>");
			else printf("|    ");
			}
		else printf("     ");
		}

	print_syntagmatic_frame(S, root->Proposition);

	stack = root->Entailments;
	for (i=0; i < stack->top; i++)
		/* for each child of root, print that child's tree */
		PrintComplexToScreen(S, stack->slots[i]);
}

void print_fields( S, the_fields)
struct SEMANTIC_NETWORK *S;     /* the semantic network */
sequence_ptr the_fields;        /* the set of fields */
{
	sequence_ptr t;
	int field_num, node;
	cons_ptr p, q, this_field, the_parts;

	/* find the frames in the field and print them */
	t = the_fields;
	field_num = 1;
	while( not( nullseq( t))) {
		printf("Field %d\n", field_num);
		this_field = carseq( t);

		/* for each node in the field, */
		/*      if its a frame id, print its frame */
		p = this_field;
		while( not( null( p))) {
			node = car(p);
			if ((GetType( S,node) == SFRAME) ||
				(GetType( S,node) == PFRAME)) {
				printf("     ");  /* a little indentation */
				print_syntagmatic_frame(S, node);
				}
			p = cdr(p); /* get next node */
			}

		/* print all the mereological relations in the field */
		print_field_parts( S, this_field);

		t = cdrseq(t);
		field_num++; /* go on to next field */
		} /* end while not nullseq t */
}


void IncongruousNP( S, TopicFrame, SourceFrame, i)
struct SEMANTIC_NETWORK *S;
int TopicFrame;
int SourceFrame;
int i;
{
	int TopicNoun, SourceNoun, TopicAdj;
	sequence_ptr PairsOfOpposites;

	TopicNoun = GetNounAtPosition(S, TopicFrame, i);
	SourceNoun = GetNounAtPosition(S, SourceFrame, i);

	PairsOfOpposites = NIL;
	PairsOfOpposites = MakePairsOfOpposites(
							S, TopicNoun, SourceNoun, PairsOfOpposites);

	if (not(nullseq(PairsOfOpposites))) {
		TopicAdj = first( carseq( PairsOfOpposites));
		printf( "[%s [%s]] ",
				GetName(S,TopicAdj),
				GetName(S,SourceNoun));
		}
	else printf("%s ", GetName(S,TopicNoun));
}
\
