
int ContrastiveRelation( S, PFrame)
struct SEMANTIC_NETWORK *S;
int PFrame;
{
	cons_ptr TheRelation;

	TheRelation = NIL;
	TheRelation = node_trans( PFrame, S,
			   CONTRAST, LITERAL, TheRelation);
	if (length(TheRelation) > 1) {
		printf("ERROR:<%s> has more than one contastive relation.\n",
				S->node_names[PFrame]);
		exit( ERROR_VALUE);
		}
	else return( car( TheRelation));
}

struct HYPOTHESIS_NET *ExtendToParaContrastSets( S, H, AnalogousPairs)
struct SEMANTIC_NETWORK *S;
struct HYPOTHESIS_NET *H;
sequence_ptr AnalogousPairs;
{
	/******************************************************************/
	/*                                                                */
	/* for each Pair in AnalogousPairs {                              */
	/*      T = first(Pair);                                          */
	/*      S = second(Pair);                                         */
	/*      if (adjective(T) & adjective(S)) {                        */
	/*         TopicParaFrames = para_trans(T, LITERAL);              */
	/*         SourceParaFrames = para_trans(S, LITERAL);             */
	/*         if (ContrastiveRelation(TopicParaFrames) ==            */
	/*              ContrastiveRelation(SourceParaFrames)) {          */
	/*              for each P in ParadigmaticRoles {                 */
	/*                  TopicAnalogue = node_trans( TopicParaFrames,  */
	/*                                         LITERAL, P);           */
	/*                  SourceAnalogue = node_trans(SourceParaFrames, */
	/*                                         LITERAL, P);           */
	/*                  AjectivalPair = cons(TopicAnalogue,           */
	/*                                      ncons(SourceAnalogue));   */
	/*                  H = AddExcitory(S, H, conseq( Pair,           */
	/*                                     nconseq(AdjectivalPair);   */
	/*                  }                                             */                                            */
	/*          }                                                     */
	/*       }                                                        */
	/* }                                                              */
	/******************************************************************/

	sequence_ptr AnaPairPtr;        /* indexes AnalogousPairs */
	cons_ptr Pair;                  /* (T,S) */
	int TopicTerm;                  /* Topic adjective */
	int SrcTerm;                    /* Source adjective */
	cons_ptr TopicParaFrame;        /* PFRAMES of T */
	cons_ptr SourceParaFrame;       /* PFRAMES of S */
	int TopicAnalogue;
	int SourceAnalogue;
	int P;                          /* a paradigmatic role */
	cons_ptr AdjectivalPair;        /* (TopicAnalogue,SourceAnalogue) */

	AnaPairPtr = AnalogousPairs;
	while (not(nullseq( AnaPairPtr))) {
	     Pair = carseq( AnaPairPtr);
	     TopicTerm = first(Pair);
	     SrcTerm = second(Pair);
	     if (is_adjective(S, TopicTerm) & is_adjective(S, SrcTerm)) {
		TopicParaFrame = NIL;
		TopicParaFrame = para_node_trans(TopicTerm,
					S, LITERAL, TopicParaFrame);
		SourceParaFrame = NIL;
		SourceParaFrame = para_node_trans(SrcTerm,
					S, LITERAL, SourceParaFrame);
		if (ContrastiveRelation(first(TopicParaFrame)) ==
		     ContrastiveRelation(first(SourceParaFrame))) {
		     for (P = FIRST_PARA_ROLE; P <= LAST_PARA_ROLE; P++) {
			 TopicAnalogue = NIL;
			 TopicAnalogue = node_trans(TopicParaFrame, S,
						P, LITERAL, TopicAnalogue);
			 SourceAnalogue = NIL;
			 SourceAnalogue = node_trans(SourceParaFrame, S,
						P, LITERAL, SourceAnalogue);
			 AjectivalPair = cons(first(TopicAnalogue),
					     ncons(first(SourceAnalogue)));
			 H = AddExcitory(S, H, conseq( Pair,
					    nconseq(AdjectivalPair);
			 } /* for each paradigmatic role */                                                                                        */
		     } /* if equal contrastive relations */
		} /* if (adjective, adjective) */
	     AnaPairPtr = cdrseq( AnaPairPtr); /* get next analogous pair */
	     } /* end while not nullseq AnaPairPtr */
	return( H);
}
