/**************************************************************************/
/*                                                                        */
/*                             User Interface                             */
/*                 Copyright (C) 1993 Eric Charles Steinhart              */
/*                                                                        */
/**************************************************************************/
#include "stdio.h"
#include "C:\qc25\include\graph.h"
#include "anadefs.h"
#include "semnet.h"

extern int IncludeFrames;
extern FILE *ExerciseFile;
extern int ExerciseFlag;
extern char ExerciseFileNames[NUM_EXERCISE_FILES][MAX_STRLEN];

#define TAB '\t'
#define BACKSPACE 8

/**************************************************************************/
/*                                                                        */
/*                           Graphics Routines                            */
/*                                                                        */
/**************************************************************************/
#define UPPER_LEFT_CORNER   0xda
#define UPPER_RIGHT_CORNER  0xbf
#define HORIZONTAL          0xc4
#define VERTICAL            0xb3
#define LOWER_LEFT_CORNER   0xc0
#define LOWER_RIGHT_CORNER  0xd9

void rectangle( start_col, start_row, end_col, end_row)
int start_col, start_row, end_col, end_row;  /* must be positive */
{

	int i;

	_settextposition( start_row, start_col);
	putch( UPPER_LEFT_CORNER);
	for (i=start_col; i < end_col-1; i++) putch( HORIZONTAL);
	putch( UPPER_RIGHT_CORNER);
	for (i=start_row+1; i < end_row; i++){
		_settextposition( i, start_col); putch( VERTICAL);
		_settextposition( i, end_col); putch( VERTICAL);
		}
	_settextposition( end_row, start_col);
	putch( LOWER_LEFT_CORNER);
	for (i=start_col; i < end_col-1; i++) putch( HORIZONTAL);
	putch( LOWER_RIGHT_CORNER);
}

posprint( row, col, string)
int row;
int col;
char *string;
{
	_settextposition( row, col);
	puts(string);
}


/**************************************************************************/
/*                                                                        */
/*                               Windows                                  */
/*                                                                        */
/**************************************************************************/

void DisplayErrorWindow( void);
#define PrintingErrorMessage 0
struct WindowStruct ErrorWindowStruct = {
	10, 21, 70, 25,
	{22, 0, 0},     /* Rows for Cursor */
	{12, 0, 0},     /* Cols for Cursor */
	0,              /* MenuMin         */
	0,              /* MenuMax         */
	&DisplayErrorWindow
	};
struct WindowStruct *ErrorWindow
						= &ErrorWindowStruct;

void DisplayErrorWindow( void)
{
	rectangle( ErrorWindow->StartCol, ErrorWindow->StartRow,
			   ErrorWindow->EndCol,   ErrorWindow->EndRow);
	posprint( 21, 35, " ERRORS ");
}

void ClearErrorWindow( void )
{
	struct rccoord LastPos;
	LastPos = _gettextposition();
	posprint( ErrorWindow->CursorRowFor[PrintingErrorMessage],
			  ErrorWindow->CursorColFor[PrintingErrorMessage],
			  "                                                ");
	_settextposition( LastPos.row, LastPos.col);
}

void PrintError( ErrorMessage)
char *ErrorMessage;
{
	posprint( ErrorWindow->CursorRowFor[PrintingErrorMessage],
			  ErrorWindow->CursorColFor[PrintingErrorMessage],
			  ErrorMessage);
}


void DisplayWelcomeWindow();
struct WindowStruct WelcomeWindowStruct = {
	10, 5, 70, 10,
	{0, 0, 0},      /* Rows for Cursor */
	{0, 0, 0},      /* Cols for Cursor */
	0,              /* MenuMin         */
	0,              /* MenuMax         */
	&DisplayWelcomeWindow
	};
struct WindowStruct *WelcomeWindow
						= &WelcomeWindowStruct;

void DisplayWelcomeWindow( void )
{
	rectangle( WelcomeWindow->StartCol, WelcomeWindow->StartRow,
			   WelcomeWindow->EndCol,   WelcomeWindow->EndRow);
	posprint(6, 16, "Semantic Field Theory of Metaphor Implementation.");
	posprint(7, 34, "Version 1.5");
	posprint(8, 23, "Copyright (C) 1993 E. Steinhart.");
	posprint(9, 30, "All rights reserved.");
}

void DisplayExerciseWindow();
struct WindowStruct ExerciseWindowStruct = {
	10, 11, 70, 18,
	{18, 18, 0},    /* Rows for Cursor */
	{22, 37, 0},    /* Cols for Cursor */
	0,              /* MenuMin         */
	0,              /* MenuMax         */
	&DisplayExerciseWindow
	};
struct WindowStruct *ExerciseWindow
						= &ExerciseWindowStruct;

void DisplayExerciseWindow( void )
{
	rectangle( ExerciseWindow->StartCol, ExerciseWindow->StartRow,
			   ExerciseWindow->EndCol,   ExerciseWindow->EndRow);
	posprint(13, 12,
		"If you're new to this program, please run the exercises.");
	posprint(15, 18, "To run the exercises, strike the TAB key.");
	posprint(16, 18, "To skip the exercises, strike the ENTER key.");
	posprint(18, 15, " ENTER continues  TAB runs exercises  ESCAPE exits ");
}


void DisplayExerciseInfoWindow();
struct WindowStruct ExerciseInfoWindowStruct = {
	10, 2, 70, 20,
	{19, 19, 0},    /* Rows for Cursor */
	{15, 46, 0},    /* Cols for Cursor */
	1,              /* MenuMin         */
	8,              /* MenuMax         */
	&DisplayExerciseInfoWindow
	};
struct WindowStruct *ExerciseInfoWindow
						= &ExerciseInfoWindowStruct;

void DisplayExerciseInfoWindow( void )
{
	rectangle( ExerciseInfoWindow->StartCol, ExerciseInfoWindow->StartRow,
			   ExerciseInfoWindow->EndCol,   ExerciseInfoWindow->EndRow);
	posprint( 4, 15, "The exercises guide you through NETMET.  Normally,");
	posprint( 5, 15, "NETMET asks you for input.  But when you run an");
	posprint( 6, 15, "exercise, all input is provided automatically.  All");
	posprint( 7, 15, "you do is strike ENTER to move from screen to screen.");
	posprint( 9, 15, "1. SOUND IS A WAVE -- Simple metaphor generation.");
	posprint(10, 15, "2. SOCRATES IS A MIDWIFE -- Metaphor generation.");
	posprint(11, 15, "3. ATOM IS A SOLAR SYSTEM -- Structural analogy.");
	posprint(12, 15, "4. MEMORY IS A WAX TABLET -- Metaphor generation.");
	posprint(13, 15, "5. MEMORY IS AN AVIARY -- Metaphor generation.");
	posprint(14, 15, "6. SOCRATES IS A MIDWIFE -- Analogical transference.");
	posprint(15, 15, "7. MEMORY IS A WAX TABLET -- Analogical transference.");
	posprint(16, 15, "8. MEMORY IS AN AVIARY -- Analogical transference.");
	posprint(18, 15, "Choose an exercise by entering a menu option.");
}


void DisplayMainWindow();
struct WindowStruct MainWindowStruct = {
	10, 11, 70, 19,
	{18, 18, 0},    /* Rows for Cursor */
	{20, 51, 0},    /* Cols for Cursor */
	1,              /* MenuMin         */
	3,              /* MenuMax         */
	&DisplayMainWindow
	};
struct WindowStruct *MainWindow
						= &MainWindowStruct;

void DisplayMainWindow( void )
{
	rectangle( MainWindow->StartCol, MainWindow->StartRow,
			   MainWindow->EndCol,   MainWindow->EndRow);
	posprint(11, 24, " SFTM Implementation Main Menu ");
	posprint(14, 25, "1. Initialize a semantic network.");
	posprint(15, 25, "2. Set parameters.");
	posprint(16, 25, "3. Quit SFTM implementation.");
}

void DisplayParameterWindow();
struct WindowStruct ParameterWindowStruct = {
	10, 11, 70, 19,
	{16, 16, 0},    /* Rows for Cursor */
	{46, 61, 0},    /* Cols for Cursor */
	0,              /* MenuMin         */
	0,              /* MenuMax         */
	&DisplayParameterWindow
	};
struct WindowStruct *ParameterWindow
						= &ParameterWindowStruct;

void DisplayParameterWindow( void )
{
	rectangle( ParameterWindow->StartCol, ParameterWindow->StartRow,
			   ParameterWindow->EndCol,   ParameterWindow->EndRow);
	posprint(11, 24, " SFTM Implementation Parameters ");
	posprint(14, 59, "DEFAULT");
	posprint(15, 15, "Include frame identifiers in analogical map? [Y]");
}

void DisplayFileNamesWindow();
struct WindowStruct FileNamesWindowStruct = {
	10, 1, 70, 20,
	{0, 0, 0},      /* Rows for Cursor */
	{0, 0, 0},      /* Cols for Cursor */
	0,              /* MenuMin         */
	0,              /* MenuMax         */
	&DisplayFileNamesWindow
	};
struct WindowStruct *FileNamesWindow
						= &FileNamesWindowStruct;

void DisplayFileNamesWindow()
{
	rectangle(FileNamesWindow->StartCol, FileNamesWindow->StartRow,
			  FileNamesWindow->EndCol,   FileNamesWindow->EndRow);
	posprint(1, 20, " Proposition Files in Current Directory ");
}


void DisplayNetworkMenuWindow();
struct WindowStruct NetworkMenuWindowStruct = {
	10, 5, 70, 20,
	{19, 19, 0},    /* Rows for Cursor */
	{15, 46, 0},    /* Cols for Cursor */
	1,              /* MenuMin         */
	10,             /* MenuMax         */
	&DisplayNetworkMenuWindow
	};
struct WindowStruct *NetworkMenuWindow
						= &NetworkMenuWindowStruct;

void DisplayNetworkMenuWindow( void )
{
	rectangle( NetworkMenuWindow->StartCol, NetworkMenuWindow->StartRow,
			   NetworkMenuWindow->EndCol,   NetworkMenuWindow->EndRow);
	posprint( 5, 20, " Semantic Field Theory of Metaphor ");
	posprint( 7, 20, " 1. Print the words in the network.");
	posprint( 8, 20, " 2. Print the propositions in the network.");
	posprint( 9, 20, " 3. Find the propositions in which a word sits.");
	posprint(10, 20, " 4. Find the fields in which a word sits.");
	posprint(11, 20, " 5. Perform analogical access.");
	posprint(12, 20, " 6. Build a hypothesis network.");
	posprint(13, 20, " 7. Generate metaphors.");
	posprint(14, 20, " 8. Metaphorical redescription.");
	posprint(15, 20, " 9. Inference engine.");
	posprint(16, 20, "10. Return to the main menu.");
}

void DisplayMessageWindow();
struct WindowStruct MessageWindowStruct = {
	10, 5, 70, 15,
	{14, 14, 0},    /* Rows for Cursor */
	{12, 54, 0},    /* Cols for Cursor */
	0,              /* MenuMin         */
	0,              /* MenuMax         */
	&DisplayMessageWindow
	};
struct WindowStruct *MessageWindow
						= &MessageWindowStruct;

void DisplayMessageWindow()
{
	rectangle(MessageWindow->StartCol, MessageWindow->StartRow,
			  MessageWindow->EndCol,   MessageWindow->EndRow);
	posprint(5, 35, " MESSAGE ");
}

void DisplayWordsWindow();
struct WindowStruct WordsWindowStruct = {
	10, 1, 70, 15,
	{14, 14, 0},    /* Rows for Cursor */
	{12, 54, 0},    /* Cols for Cursor */
	0,              /* MenuMin         */
	0,              /* MenuMax         */
	&DisplayWordsWindow
	};
struct WindowStruct *WordsWindow
						= &WordsWindowStruct;

void DisplayWordsWindow()
{
	rectangle(WordsWindow->StartCol, WordsWindow->StartRow,
			  WordsWindow->EndCol,   WordsWindow->EndRow);
	posprint(1, 25, " Words in the Semantic Network ");
	posprint(15,21, " ENTER continues  ESCAPE quits program ");
}

void DisplayTermsWindow();
struct WindowStruct TermsWindowStruct = {
	10, 1, 70, 15,
	{14, 14, 0},    /* Rows for Cursor */
	{12, 54, 0},    /* Cols for Cursor */
	0,              /* MenuMin         */
	0,              /* MenuMax         */
	&DisplayTermsWindow
	};
struct WindowStruct *TermsWindow
						= &TermsWindowStruct;

void DisplayTermsWindow()
{
	rectangle(TermsWindow->StartCol, TermsWindow->StartRow,
			  TermsWindow->EndCol,   TermsWindow->EndRow);
	posprint(1, 25, " Words in the Semantic Network ");
}


void DisplayFrameScrollWindow();
struct WindowStruct FrameScrollWindowStruct = {
	1, 1, 79, 22,
	{0, 0, 0},      /* Rows for Cursor */
	{0, 0, 0},      /* Cols for Cursor */
	0,              /* MenuMin         */
	0,              /* MenuMax         */
	&DisplayFrameScrollWindow
	};
struct WindowStruct *FrameScrollWindow
						= &FrameScrollWindowStruct;

void DisplayFrameScrollWindow()
{
	rectangle(FrameScrollWindow->StartCol,FrameScrollWindow->StartRow,
			  FrameScrollWindow->EndCol,  FrameScrollWindow->EndRow);
	posprint(1, 25, " Propositions in the Network ");
	posprint(22, 8,
		" UP scrolls up  DOWN scrolls down  ENTER continues  ESCAPE quits ");
}

void DisplayInferenceScrollWindow();
struct WindowStruct InferenceScrollWindowStruct = {
	10, 1, 70, 15,
	{14, 14, 0},    /* Rows for Cursor */
	{12, 54, 0},    /* Cols for Cursor */
	0,              /* MenuMin         */
	0,              /* MenuMax         */
	&DisplayInferenceScrollWindow
	};
struct WindowStruct *InferenceScrollWindow
						= &InferenceScrollWindowStruct;

void DisplayInferenceScrollWindow()
{
	rectangle(InferenceScrollWindow->StartCol, InferenceScrollWindow->StartRow,
			  InferenceScrollWindow->EndCol,   InferenceScrollWindow->EndRow);
	posprint(1, 21, " Propositions in the Semantic Network ");
	posprint(15,15,
		" UP & DOWN to scroll  ENTER to select  ESCAPE quits ");
}


void DisplayTransferenceScrollWindow();
struct WindowStruct TransferenceScrollWindowStruct = {
	10, 1, 70, 15,
	{14, 14, 0},    /* Rows for Cursor */
	{12, 54, 0},    /* Cols for Cursor */
	0,              /* MenuMin         */
	0,              /* MenuMax         */
	&DisplayTransferenceScrollWindow
	};
struct WindowStruct *TransferenceScrollWindow
						= &TransferenceScrollWindowStruct;

void DisplayTransferenceScrollWindow()
{
	rectangle(TransferenceScrollWindow->StartCol, TransferenceScrollWindow->StartRow,
			  TransferenceScrollWindow->EndCol,   TransferenceScrollWindow->EndRow);
	posprint(1, 17, " Propositions Transferred to the Target Field ");
	posprint(15,15,
		" UP & DOWN to scroll  ENTER to select  ESCAPE quits ");
}

void DisplayFrameNodeQueryWindow();
struct WindowStruct FrameNodeQueryWindowStruct = {
	10, 16, 70, 20,
	{18, 18, 0},    /* Rows for Cursor */
	{15, 30, 0},    /* Cols for Cursor */
	0,              /* MenuMin         */
	0,              /* MenuMax         */
	&DisplayFrameNodeQueryWindow
	};
struct WindowStruct *FrameNodeQueryWindow
						= &FrameNodeQueryWindowStruct;

void DisplayFrameNodeQueryWindow()
{
	rectangle(FrameNodeQueryWindow->StartCol, FrameNodeQueryWindow->StartRow,
			  FrameNodeQueryWindow->EndCol,   FrameNodeQueryWindow->EndRow);
	posprint(16, 20, " Propositions are Generated from a word ");
}


void DisplayFieldNodeQueryWindow();
struct WindowStruct FieldNodeQueryWindowStruct = {
	10, 16, 70, 20,
	{18, 18, 0},    /* Rows for Cursor */
	{15, 30, 0},    /* Cols for Cursor */
	0,              /* MenuMin         */
	0,              /* MenuMax         */
	&DisplayFieldNodeQueryWindow
	};
struct WindowStruct *FieldNodeQueryWindow
						= &FieldNodeQueryWindowStruct;

void DisplayFieldNodeQueryWindow()
{
	rectangle(FieldNodeQueryWindow->StartCol, FieldNodeQueryWindow->StartRow,
			  FieldNodeQueryWindow->EndCol,   FieldNodeQueryWindow->EndRow);
	posprint(16, 18, " Semantic Fields are Generated from a word ");
}


void DisplayTopicNodeQueryWindow();
struct WindowStruct TopicNodeQueryWindowStruct = {
	10, 16, 70, 20,
	{18, 18, 0},    /* Rows for Cursor */
	{15, 30, 0},    /* Cols for Cursor */
	0,              /* MenuMin         */
	0,              /* MenuMax         */
	&DisplayTopicNodeQueryWindow
	};
struct WindowStruct *TopicNodeQueryWindow
						= &TopicNodeQueryWindowStruct;

void DisplayTopicNodeQueryWindow()
{
	rectangle(TopicNodeQueryWindow->StartCol, TopicNodeQueryWindow->StartRow,
			  TopicNodeQueryWindow->EndCol,   TopicNodeQueryWindow->EndRow);
	posprint(16, 18, " The Topic Field is Generated from a Word ");
}


void DisplaySourceNodeQueryWindow();
struct WindowStruct SourceNodeQueryWindowStruct = {
	10, 16, 70, 20,
	{18, 18, 0},    /* Rows for Cursor */
	{15, 30, 0},    /* Cols for Cursor */
	0,              /* MenuMin         */
	0,              /* MenuMax         */
	&DisplaySourceNodeQueryWindow
	};
struct WindowStruct *SourceNodeQueryWindow
						= &SourceNodeQueryWindowStruct;

void DisplaySourceNodeQueryWindow()
{
	rectangle(SourceNodeQueryWindow->StartCol,SourceNodeQueryWindow->StartRow,
			  SourceNodeQueryWindow->EndCol,  SourceNodeQueryWindow->EndRow);
	posprint(16, 18, " The Source Fields are Generated from a Word ");
}


void DisplayPropNodeQueryWindow();
struct WindowStruct PropNodeQueryWindowStruct = {
	10, 16, 70, 20,
	{18, 18, 0},    /* Rows for Cursor */
	{15, 37, 0},    /* Cols for Cursor */
	0,              /* MenuMin         */
	0,              /* MenuMax         */
	&DisplayPropNodeQueryWindow
	};
struct WindowStruct *PropNodeQueryWindow
						= &PropNodeQueryWindowStruct;

void DisplayPropNodeQueryWindow()
{
	rectangle(PropNodeQueryWindow->StartCol, PropNodeQueryWindow->StartRow,
			  PropNodeQueryWindow->EndCol,   PropNodeQueryWindow->EndRow);
	posprint(16, 20, " Select a proposition for interpretation ");
}


void DisplaySourceMenuWindow();
struct WindowStruct SourceMenuWindowStruct = {
	10, 5, 70, 20,
	{19, 19, 0},    /* Rows for Cursor */
	{15, 46, 0},    /* Cols for Cursor */
	1,              /* MenuMin         */
	2,              /* MenuMax         */
	&DisplaySourceMenuWindow
	};
struct WindowStruct *SourceMenuWindow
						= &SourceMenuWindowStruct;

void DisplaySourceMenuWindow()
{
	rectangle(SourceMenuWindow->StartCol,SourceMenuWindow->StartRow,
			  SourceMenuWindow->EndCol,  SourceMenuWindow->EndRow);
	posprint(5, 15, " Select a Method for Source Field Construction ");
}

void DisplayFieldWindow();
struct WindowStruct FieldWindowStruct = {
	10, 5, 70, 19,
	{16, 16, 7},    /* Rows for Cursor */
	{15, 46, 15},   /* Cols for Cursor */
	1,              /* MenuMin         */
	4,              /* MenuMax         */
	&DisplayFieldWindow
	};
struct WindowStruct *FieldWindow
						= &FieldWindowStruct;

void DisplayFieldWindow()
{
	rectangle( FieldWindow->StartCol, FieldWindow->StartRow,
			   FieldWindow->EndCol,   FieldWindow->EndRow);
	posprint(5, 23, " Methods for Finding Semantic Fields ");
	posprint(9,  20, "Functional fields");
	posprint(10, 20, "    with NO mereological closure:           1");
	posprint(11, 20, "    with mereological closure                ");
	posprint(12, 20, "         by method of least maximal whole:  2");
	posprint(13, 20, "         by method of maximal whole:        3");
	posprint(14, 20, "Structural field:                           4");
}


void DisplayFieldScrollWindow();
struct WindowStruct FieldScrollWindowStruct = {
	1, 1, 79, 22,
	{0, 0, 0},      /* Rows for Cursor */
	{0, 0, 0},      /* Cols for Cursor */
	0,              /* MenuMin         */
	0,              /* MenuMax         */
	&DisplayFieldScrollWindow
	};
struct WindowStruct *FieldScrollWindow
						= &FieldScrollWindowStruct;

void DisplayFieldScrollWindow()
{
	rectangle(FieldScrollWindow->StartCol,FieldScrollWindow->StartRow,
			  FieldScrollWindow->EndCol,  FieldScrollWindow->EndRow);
	posprint(1, 20, " Semantic Fields For Analogical Reasoning ");
	posprint(22, 8,
		" UP scrolls up  DOWN scrolls down  ENTER continues  ESCAPE quits ");
}


void DisplayFieldChoiceWindow();
struct WindowStruct FieldChoiceWindowStruct = {
	1, 23, 79, 25,
	{24, 24, 24},   /* Rows for Cursor */
	{ 5, 47,  5},   /* Cols for Cursor */
	0,              /* MenuMin         */
	0,              /* MenuMax         */
	&DisplayFieldChoiceWindow
	};
struct WindowStruct *FieldChoiceWindow
						= &FieldChoiceWindowStruct;

void DisplayFieldChoiceWindow()
{
	rectangle(FieldChoiceWindow->StartCol,FieldChoiceWindow->StartRow,
			  FieldChoiceWindow->EndCol,  FieldChoiceWindow->EndRow);
}

void DisplayAnalogyScrollWindow();
struct WindowStruct AnalogyScrollWindowStruct = {
	1, 1, 79, 24,
	{0, 0, 0},      /* Rows for Cursor */
	{0, 0, 0},      /* Cols for Cursor */
	0,              /* MenuMin         */
	0,              /* MenuMax         */
	&DisplayAnalogyScrollWindow
	};
struct WindowStruct *AnalogyScrollWindow
						= &AnalogyScrollWindowStruct;

void DisplayAnalogyScrollWindow()
{
	rectangle(AnalogyScrollWindow->StartCol,AnalogyScrollWindow->StartRow,
			  AnalogyScrollWindow->EndCol,  AnalogyScrollWindow->EndRow);
	posprint(1, 19, " Process of Building the Hypothesis Network ");
	posprint(24, 8,
		" UP scrolls up  DOWN scrolls down  ENTER continues  ESCAPE quits ");
}


void DisplayHypoScrollWindow();
struct WindowStruct HypoScrollWindowStruct = {
	1, 1, 79, 24,
	{1, 18, 0},     /* Rows for Cursor */
	{15, 5, 0},     /* Cols for Cursor */
	0,              /* MenuMin         */
	0,              /* MenuMax         */
	&DisplayHypoScrollWindow
	};
struct WindowStruct *HypoScrollWindow
						= &HypoScrollWindowStruct;

void DisplayHypoScrollWindow()
{
	rectangle(HypoScrollWindow->StartCol,HypoScrollWindow->StartRow,
			  HypoScrollWindow->EndCol,  HypoScrollWindow->EndRow);
	posprint(1, 20, " Connections in the Hypothesis Network ");
	posprint(24, 8,
		" UP scrolls up  DOWN scrolls down  ENTER continues  ESCAPE quits ");
}

void DisplayActivationsWindow();
struct WindowStruct ActivationsWindowStruct = {
	1, 1, 79, 22,
	{0, 0, 0},      /* Rows for Cursor */
	{0, 0, 0},      /* Cols for Cursor */
	0,              /* MenuMin         */
	0,              /* MenuMax         */
	&DisplayActivationsWindow
	};
struct WindowStruct *ActivationsWindow
						= &ActivationsWindowStruct;

void DisplayActivationsWindow()
{
	rectangle(ActivationsWindow->StartCol,ActivationsWindow->StartRow,
			  ActivationsWindow->EndCol,  ActivationsWindow->EndRow);
	posprint(1, 25, " Activations of Match Hypotheses ");
	posprint(22,21, " ENTER continues  ESCAPE quits program ");
}

void DisplayStartMetsWindow();
struct WindowStruct StartMetsWindowStruct = {
	10, 5, 70, 20,
	{19, 19, 0},    /* Rows for Cursor */
	{15, 53, 0},    /* Cols for Cursor */
	0,              /* MenuMin         */
	0,              /* MenuMax         */
	&DisplayStartMetsWindow
	};
struct WindowStruct *StartMetsWindow
						= &StartMetsWindowStruct;

void DisplayStartMetsWindow()
{
	rectangle(StartMetsWindow->StartCol, StartMetsWindow->StartRow,
			  StartMetsWindow->EndCol,   StartMetsWindow->EndRow);
	posprint(5, 25, " Process for Generating Metaphors ");
	posprint(7, 15, "  I. The Access Phase proceeds like this:");
	posprint(8, 15, "     1. Generate the Target Field.");
	posprint(9, 15, "     2. Generate Candidate Source Fields.");
	posprint(10,15, "     3. Select the Source Field.");
	posprint(12,15, " II. The Mapping Phase proceeds like this:");
	posprint(13,15, "     1. Generate a Match Hypothesis Net.");
	posprint(14,15, "     2. Run the Match Hypothesis Net to Convergence.");
	posprint(15,15, "     3. Select Winning Match Hypotheses for Map.");
	posprint(17,15, "III. Generate Metaphors.");
	posprint(20,21, " ENTER continues  ESCAPE quits program ");
}


void DisplayMetaphorWindow();
struct WindowStruct MetaphorWindowStruct = {
	1, 1, 79, 22,
	{0, 0, 0},      /* Rows for Cursor */
	{0, 0, 0},      /* Cols for Cursor */
	0,              /* MenuMin         */
	0,              /* MenuMax         */
	&DisplayMetaphorWindow
	};
struct WindowStruct *MetaphorWindow
						= &MetaphorWindowStruct;

void DisplayMetaphorWindow()
{
	rectangle(MetaphorWindow->StartCol,MetaphorWindow->StartRow,
			  MetaphorWindow->EndCol,  MetaphorWindow->EndRow);
	posprint(1, 35, " Metaphors ");
	posprint(22, 8,
		" UP scrolls up  DOWN scrolls down  ENTER continues  ESCAPE quits ");
}


void DisplayLogicScrollWindow();
struct WindowStruct LogicScrollWindowStruct = {
	1, 1, 79, 22,
	{0, 0, 0},      /* Rows for Cursor */
	{0, 0, 0},      /* Cols for Cursor */
	0,              /* MenuMin         */
	0,              /* MenuMax         */
	&DisplayLogicScrollWindow
	};
struct WindowStruct *LogicScrollWindow
						= &LogicScrollWindowStruct;

void DisplayLogicScrollWindow()
{
	rectangle(LogicScrollWindow->StartCol,LogicScrollWindow->StartRow,
			  LogicScrollWindow->EndCol,  LogicScrollWindow->EndRow);
	posprint(1, 30, " Implication Complex ");
	posprint(22, 8,
		" UP scrolls up  DOWN scrolls down  ENTER continues  ESCAPE quits ");
}


void DisplayExtraMsg( Window, Msg)
struct WindowStruct *Window;
char *Msg;
{
	posprint( Window->CursorRowFor[ExtraMessage],
			  Window->CursorColFor[ExtraMessage],
			  Msg);
}

void DisplayWindow( Window)
struct WindowStruct *Window;
{
	if (Window->Initializer != NIL)
			(*(Window->Initializer))();
}

/**************************************************************************/
/*                                                                        */
/*                              Query Routines                            */
/*                                                                        */
/**************************************************************************/
void QueryAndResponse( Window, Message)
struct WindowStruct *Window;
char *Message;
{
	posprint( Window->CursorRowFor[QueryMessage],
			  Window->CursorColFor[QueryMessage],
			  Message);
	_settextposition( Window->CursorRowFor[UserResponse],
					  Window->CursorColFor[UserResponse]);
}

void ClearWindowQueryMessage( Window)
struct WindowStruct *Window;
{
	posprint( Window->CursorRowFor[QueryMessage],
			  Window->CursorColFor[QueryMessage],
			  "                                                ");
}

void ClearWindowUserResponse( Window, nchars)
struct WindowStruct *Window;
{
	int i;
	_settextposition( Window->CursorRowFor[QueryMessage],
					  Window->CursorColFor[QueryMessage]);
	for (i = 0; i < nchars; i++) putch(' ');
}

void ExitFromWindow( Window )
struct WindowStruct *Window;
{
	char c;

	while( TRUE) {
		c = getch();
		if (c == ENTER) return;
		if (c == ESCAPE) {
			_clearscreen( _GCLEARSCREEN);
			_settextcursor( STANDARD_CURSOR);
			printf("Exiting SFTM implementation.\n");
			exit(0);
			}
		}
}

int GetResponseFromExerciseWindow( void )
{
	char c;

	while( TRUE) {
		c = getch();
		if (c == ENTER) return(FALSE); /* don't run exercises */
		if (c == TAB) return(TRUE);    /* run the exercises */
		if (c == ESCAPE) {
			_clearscreen( _GCLEARSCREEN);
			_settextcursor( STANDARD_CURSOR);
			printf("Exiting SFTM implementation.\n");
			exit(0);
			}
		}
}

void strike_any_key( void )
{
	char c;

/*    _settextcursor( STANDARD_CURSOR);*/
	printf("\nENTER continues; ESCAPE exits.\n");
	c = getch();
	switch (c) {
		case ENTER: break;
		case ESCAPE:
			printf("Exiting SFTM implementation.\n");
			exit(0);
		default: break;
		}
/*    _settextcursor( NO_CURSOR);*/
}

/* queries the user for yes or no */
int y_or_np()
{

	char answer;

	_settextcursor( STANDARD_CURSOR);
	while( TRUE) {
		printf("Enter Y or N: ");
		answer = getch();
		printf("%c\n", answer);
		if ((answer == 'Y') || (answer == 'y'))
			return( YES);
		else if ((answer == 'N') || (answer == 'n'))
			return( NO);
		printf("Must enter Y or N.\n");
		}
	_settextcursor( NO_CURSOR);
}

/* queries for yes or no within a window */
int GetYesOrNoFromWindow( Window)
struct WindowStruct *Window;
{

	char answer;
	char token[MAX_STRLEN];
	char ch;

	_settextcursor( STANDARD_CURSOR);
	if (not( ExerciseFlag)) {
		while( TRUE) {
			answer = getch();
			printf("%c\n", answer);
			if ((answer == 'Y') || (answer == 'y'))
				return( YES);
			else if ((answer == 'N') || (answer == 'n'))
				return( NO);
			ClearWindowQueryMessage( Window);
			QueryAndResponse( Window, "Enter Y or N: [ ]");
			}
		}
	else {
		fscanf(ExerciseFile, "%s", token);
		printf("%s", token);
		/* wait for the user to strike ENTER */
		ch = getch();
		while (not(ch == ENTER)) ch = getch();
		if ((token[0] == 'Y') || (token[0] == 'y'))
			return( YES);
		else if ((token[0] == 'N') || (token[0] =='n'))
			return( NO);
		else {
			_clearscreen( _GCLEARSCREEN);
			printf("ERROR:Unexpected token in exercise file.");
			exit( ERROR_VALUE);
			}
		}
	_settextcursor( NO_CURSOR);
}

/* puts the string it reads into token */
void GetConsoleFileName( token, nchars )
char *token;
int nchars;
{
	char ch;
	int i;

	_settextcursor( STANDARD_CURSOR);
	if (not( ExerciseFlag)) {
		/* skip white space */
		ch = getch();
		while (not(isalnum(ch))) ch = getch();

		/* read a sequence of alphanumerics */
		/* stop if a non-alphanumeric is encountered */
		i = 0;
		while ((isalnum(ch) || (ch == '.')) && (i < nchars)) {
			putch(ch); /* echo */
			token[i] = ch;
			ch = getch();
			i++;
			}
		ungetch(ch);
		token[i] = 0;
		}
	else {
		fscanf(ExerciseFile, "%s", token);
		printf("%s", token);
		/* wait for the user to strike ENTER */
		ch = getch();
		while (not(ch == ENTER)) ch = getch();
		}
	_settextcursor( NO_CURSOR);
}

/* puts the string it reads into token */
void GetConsoleString( token, nchars )
char *token;
int nchars;
{
	char ch;
	int i;

	_settextcursor( STANDARD_CURSOR);
	if (not( ExerciseFlag)) {
		/* skip white space */
		ch = getch();
		while (not(isalnum(ch))) ch = getch();

		/* read a sequence of alphanumerics */
		/* stop if a non-alphanumeric is encountered */
		i = 0;
		while (isalnum(ch) && (i < nchars)) {
			putch(ch); /* echo */
			token[i] = ch;
			ch = getch();
			i++;
			}
		token[i] = 0;
		}
	else {
		fscanf(ExerciseFile, "%s", token);
		printf("%s", token);
		/* wait for the user to strike ENTER */
		ch = getch();
		while (not(ch == ENTER)) ch = getch();
		}
	_settextcursor( NO_CURSOR);
}

int GetConsoleInt( nchars )
int nchars;
{
	char ch;
	int i, length;
	char token[MAX_STRLEN];

	_settextcursor( STANDARD_CURSOR);
	if (not( ExerciseFlag)) {
		/* skip white space */
		ch = getch();
		while (not(isdigit(ch))) ch = getch();

		/* read a sequence of alphanumerics */
		/* stop if a non-alphanumeric is encountered */
		i = 0;
		while (isdigit(ch) && (i < nchars)) {
			putch(ch); /* echo */
			token[i] = ch;
			ch = getch();
			i++;
			}
		token[i] = 0;
		sscanf(token, "%d", &i);
		}
	else {
		fscanf(ExerciseFile, "%s", &token);
		length = strlen( token);
		for (i=0; i < length; i++) putch(token[i]);
		sscanf(token, "%d", &i);
		/* wait for the user to strike ENTER */
		ch = getch();
		while (not(ch == ENTER)) ch = getch();
		}
	_settextcursor( NO_CURSOR);
	return( i);
}

int query_user_for_proposition( S, Window )
struct SEMANTIC_NETWORK *S;     /* the semantic network */
struct WindowStruct *Window;
{
	int need_node;
	char cue[MAX_STRLEN];
	char ErrorMsg[80];
	int index;

	_settextcursor( STANDARD_CURSOR);
	need_node = TRUE;
	while( need_node ) {

		/* ask the user to enter a node name */
		QueryAndResponse( Window, "Enter a proposition: [               ]");

		GetConsoleString( cue, MAX_STRLEN);
		/* lookup node name in semantic net */
		index = name_lookup( cue, GetNodeNames(S), GetNumNodes(S));
		if (index == STR_NOT_FOUND_ERROR) {
			sprintf( ErrorMsg,
					 "Proposition <%s> is not in the network.\n", cue);
			PrintError( ErrorMsg);
			}
		else need_node = FALSE; /* got a valid node */
		}
	_settextcursor( NO_CURSOR);
	return( index );
}

int query_user_for_node( S, Window )
struct SEMANTIC_NETWORK *S;     /* the semantic network */
struct WindowStruct *Window;
{
	int need_node;
	char cue[MAX_STRLEN];
	char ErrorMsg[80];
	int index;

	_settextcursor( STANDARD_CURSOR);
	need_node = TRUE;
	while( need_node ) {

		/* ask the user to enter a node name */
		QueryAndResponse( Window, "Enter a word: [               ]");

		GetConsoleString( cue, MAX_STRLEN);
		/* lookup node name in the semantic net */
		index = name_lookup( cue, GetNodeNames(S), GetNumNodes(S));
		if (index == STR_NOT_FOUND_ERROR) {
			sprintf( ErrorMsg,
					 "Word <%s> is not in the network.\n", cue);
			PrintError( ErrorMsg);
			}
		else need_node = FALSE; /* got a valid node */
		}
	_settextcursor( NO_CURSOR);
	return( index );
}

/* query the user for a number between min and max */
int get_option( Window)
struct WindowStruct *Window;
{
	int need_option;
	int option;
	char ErrorMsg[80];

	_settextcursor( STANDARD_CURSOR);
	/* get the selection from the user */
	need_option = TRUE;
	while( need_option) {

		QueryAndResponse( Window, "Enter a menu option by number [  ]");

		option = GetConsoleInt(2);

		ClearErrorWindow();
		if (option >= Window->MenuMin && option <= Window->MenuMax)
			/* valid option selected */
			need_option = FALSE;
		else {
			sprintf(ErrorMsg,
				"Must enter a number from %d to %d.\n",
				Window->MenuMin, Window->MenuMax);
			PrintError( ErrorMsg);
			ClearWindowUserResponse( Window, 2);
			}
		}
	_settextcursor( NO_CURSOR);
	return( option);
}

/* selects one field from a sequence of fields */
cons_ptr select_one_field( candidates, result, Window)
sequence_ptr candidates;        /* the sequence of fields */
cons_ptr result;                /* the chosen field */
struct WindowStruct *Window;
{
	int i;
	sequence_ptr x;
	int field_number;
	int need_field_number;
	int length_candidates;
	char QueryMsg[80];

	_settextcursor( STANDARD_CURSOR);
	field_number = 0;
	length_candidates = lengthseq( candidates);
	need_field_number = TRUE;

	/* print the first message */
	QueryAndResponse(Window, "Choose a field by entering field number: [ ]");

	while( need_field_number) {
		/* get a field number */
		field_number = GetConsoleInt(1);

		if ((field_number < 1) || (field_number > length_candidates)) {
			sprintf( QueryMsg, "Must enter an integer between 1 and %d: ",
					 length_candidates);
			QueryAndResponse( Window, QueryMsg);
			}
		else need_field_number = FALSE;
		} /* end while need_field_number */

	/* find and return the field_number-th field */
	x = candidates;
	for( i = 1; i < field_number; i++) x = cdrseq( x);
	result = carseq( x);
	_settextcursor( NO_CURSOR);
	return( result);
}


/**************************************************************************/
/*                                                                        */
/*                           User Interface Functions                     */
/*                                                                        */
/**************************************************************************/
void set_parameters()
{
	int Parameter1;

	_clearscreen( _GCLEARSCREEN);
	DisplayWindow( ParameterWindow);
	QueryAndResponse( ParameterWindow, "Enter Y or N: [ ]");
	Parameter1 = GetYesOrNoFromWindow( ParameterWindow);
	if (Parameter1) IncludeFrames = TRUE;
	else IncludeFrames = FALSE;
}

void do_net_menu( sem_net)
struct SEMANTIC_NETWORK *sem_net;
{
	int option;
	int within_menu;

	/* main menu loop */
	within_menu = TRUE;
	while( within_menu ) {
		_clearscreen( _GCLEARSCREEN);
		DisplayWindow( NetworkMenuWindow);
		DisplayWindow( ErrorWindow);
		option = get_option( NetworkMenuWindow);
		_clearscreen( _GCLEARSCREEN);
		switch (option) {
			case 1: /* print the terms in the network */
				PrintTermsInNetwork( sem_net);
				break;
			case 2: /* print the frames in the network */
				PrintNetworkFramesToBuffer( sem_net);
				break;
			case 3: /* finding the frames for a term */
				printf("Find the frames for a term.\n");
				find_frames( sem_net);
				break;
			case 4: /* finding the fields of a term */
				find_fields( sem_net);
				break;
			case 5: /* perform analogical access */
				access_phase( sem_net);
				break;
			case 6: /* build hypothesis network */
				mapping_with_network( sem_net);
				break;
			case 7: /* generate metaphors */
				generate_metaphors( sem_net);
				break;
			case 8: /* metaphorical redescription */
				metaphorical_redescription( sem_net);
				break;
			case 9: /* run the inference engine */
				InferenceEngine( sem_net);
				break;
			case 10: /* exit from the network menu */
				within_menu = FALSE;
				break;
			default: /* ERROR */
				printf("ERROR: Unexpected option in net menu.\n");
				exit( ERROR_VALUE);
				break;
			} /* end switch on network menu options */
		} /* end within net menu while */
}

void DoMainMenu( void)
{
	int option;
	int within_main;        /* within main menu flag */

	/* main menu loop */
	within_main = TRUE;
	while( within_main ) {
		_clearscreen( _GCLEARSCREEN);
		DisplayWindow( MainWindow);
		DisplayWindow( ErrorWindow);
		option = get_option(MainWindow);
		switch (option) {
			case 1: /* initialize the network */
				MakeAndUseSemanticNet();
				break;
			case 2: /* set parameters */
				set_parameters();
				break;
			case 3: /* exit the main menu */
				within_main = FALSE;
				break;
			default: /* ERROR */
				printf(
				"ERROR: Unexpected option in main menu.\n");
				exit( ERROR_VALUE);
				break;
			} /* end switch on main menu options */
		} /* end within main menu while */
	_clearscreen( _GCLEARSCREEN);
}

void DoIntroductoryMenu( void)
{
	int ExerciseFileNum;
	int WantsToDoExercises;
	int WantsToContinue;
	int option;
	char ch;

	_clearscreen( _GCLEARSCREEN);
	DisplayWindow( WelcomeWindow);

	if (NUM_EXERCISE_FILES == 0) {
		/* no exercise files are defined; go straight to main menu */
		DoMainMenu();
		return;
		}

	/* ask if the user wants to do exercises */
	DisplayWindow( ExerciseWindow);
	WantsToDoExercises = GetResponseFromExerciseWindow();

	if (WantsToDoExercises) {
		ExerciseFileNum = 0;

		/* display information concerning exercises */
		_clearscreen( _GCLEARSCREEN);
		DisplayWindow( ExerciseInfoWindow);
		DisplayWindow( ErrorWindow);
		option = get_option( ExerciseInfoWindow) - 1;

		/* open exercise file for reading */
		ExerciseFile = fopen( ExerciseFileNames[option], "r");
		if (ExerciseFile == NULL) {
				_clearscreen( _GCLEARSCREEN);
				printf("ERROR:Unable to open exercise file <%s>.\n",
						ExerciseFileNames[option]);
				exit(ERROR_VALUE);
				}

		/* all further input will be read from the relevant file */
		ExerciseFlag = TRUE;

		DoMainMenu();
		fclose(ExerciseFile);
		ExerciseFlag = FALSE;

		_clearscreen( _GCLEARSCREEN);
		printf("Exiting SFTM implementation.\n");
		} /* end WantsToDoExercises */
	else DoMainMenu();
}
