/***********************************************************************/
/*                                                                     */
/*                        LIST PROCESSING FUNCTIONS                    */
/*                Copyright (C) 1992 Eric Charles Steinhart            */
/*                            All rights reserved.                     */
/*                                                                     */
/***********************************************************************/
/* Library of functions for processing lists of network nodes */

/* cons creates and returns a new cons cell whose car is this_data */
/* and whose cdr is list. */
/* space for this new cons cell is allocated on the heap */
cons_ptr cons( this_data, list )
cons_data this_data;
cons_ptr list;
{
	cons_ptr s;
	s = (cons_ptr) malloc( (size_t)sizeof( struct cons_cell));
	if (s == NULL) {
		printf("ERROR: Out of memory.\n");
		exit( ERROR_VALUE);
		}
	/* set car to this_data */
	s->cell_data = this_data;
	/* set cdr to list */
	s->next = list;
	return( s );
}

/* ncons() creates and returns a new cons */
/* whose car is object and whose cdr is nil */
cons_ptr ncons( this_data )
cons_data this_data;
{
	return( cons( this_data, NIL));
}

/* test for a null list */
int null( list )
cons_ptr list;
{
	return( (list==NIL) ? TRUE : FALSE);
}

/* retrieve the car of a cons cell */
cons_data car( list )
cons_ptr list;
{
	return( null( list) ? NIL : list->cell_data);
}

/* first() is a synonym for car() */
cons_data first( list )
cons_ptr list;
{
	return( null( list) ? NIL : list->cell_data);
}

/* retrieve the cdr of a cons cell */
cons_ptr cdr( list )
cons_ptr list;
{
	return( null( list) ? NIL : list->next);
}

/* returns the second element in a list */
int second( list)
cons_ptr list;
{
	return( car(cdr( list)));
}

/* returns a pointer to the last element of a list */
cons_ptr last( list)
cons_ptr list;
{
	cons_ptr x;
	x = list;
	if (null( list))
		return( NIL);
	else while (not( null( x))) {
		if (null(cdr(x))) return( x);
		x = cdr(x);
		}
}

/* check for membership in a list */
int is_member( this_data, list )
cons_data this_data;
cons_ptr list;
{
	if ( null( list))
		return( FALSE);
	else if ( car( list) == this_data)
		return( TRUE);
		else return( is_member( this_data, cdr( list)));
}

/* determines whether list1 is a subset of list2 */
int is_subset( list1, list2 )
cons_ptr list1;
cons_ptr list2;
{
	cons_ptr t;
	int result;

	result = TRUE;
	t = list1;
	while( not( null( t))) {
		result = result && is_member( car( t), list2);
		t = cdr(t);
		}
	return( result);
}

/* return the length of a list */
/* length of the null list is 0 */
int length( list)
cons_ptr list;
{
	cons_ptr s;
	int list_len;
	s = list;
	list_len = 0;
	if ( null( s))
		return( 0);
	else while ( not( null( s))) {
		list_len++;
		s = cdr( s);
		}
	return( list_len);
}

/* computes list1 - list2 and returns it */
/* note that the result is a list */
cons_ptr setdiff( list1, list2, result)
cons_ptr list1;
cons_ptr list2;
cons_ptr result;
{
	/* for each item in list1, */
	/*     if item is not in list2, then cons it onto result */
	cons_ptr s;
	s = list1;
	while ( not( null( s))) {
		if not( is_member( car( s), list2))
			result = cons( car( s), result);
		s = cdr( s); /* get next s */
		}
	return( result);
}

/* the intersection of list1 and list2 and returns it */
/* note that the result is a list */
cons_ptr intersect( list1, list2, result)
cons_ptr list1;
cons_ptr list2;
cons_ptr result;
{
	/* for each item in list1, */
	/*     if item is in list2, then cons it onto result */
	cons_ptr s;
	s = list1;
	while ( not( null( s))) {
		if ( is_member( car( s), list2))
			result = cons( car( s), result);
		s = cdr( s); /* get next s */
		}
	return( result);
}

/* compute the union of two lists */
/* the second list is modified */
cons_ptr list_union( list1, list2)
cons_ptr list1;
cons_ptr list2;
{
	cons_ptr s;
	s = list1;
	while ( not( null( s))) {
		if ( not( is_member( car( s), list2)))
			list2 = cons( car( s), list2);
		s = cdr( s);
		}
	return( list2);
}

/* append an int onto the end of a list */
cons_ptr list_append( list1, item)
cons_ptr list1;
int item;
{
	cons_ptr listlast;

/*      printf("ENTER: list_append\n");*/
	if (null( list1)) return( ncons(item));

	/* go to the end of the list */
	listlast = last(list1);
	listlast->next = ncons(item);
/*      printf("EXIT: list_append\n");*/
	return( list1);
}

/* determine set equality */
/* returns TRUE if (x in list1) <==> (x in list2), FALSE otherwise */
int equal( list1, list2)
cons_ptr list1;
cons_ptr list2;
{
	cons_ptr s, t;

	if ( not( length( list1) == length( list2)))
		return( FALSE);
	else { /* lists have same number of elements */
		s = list1;
		t = list2;
		while ( not( null( s))) {
			if not( car(s) == car(t)) return( FALSE);
			s = cdr( s);
			t = cdr( t);
			}
		return( TRUE);
		}
}

/* determine list equality */
/* returns TRUE if list1 == list2, FALSE otherwise */
int list_equal( list1, list2)
cons_ptr list1;
cons_ptr list2;
{
	cons_ptr s;

	if ( not( length( list1) == length( list2)))
		return( FALSE);
	else { /* lists have same number of elements */
		s = list1;
		while ( not( null( s))) {
			if not( is_member( car( s), list2))
				return( FALSE);
			s = cdr( s);
			}
		return( TRUE);
		}
}

/* prints the members of a list as integers */
int print_list( list)
cons_ptr list;
{
	cons_ptr s;
	s = list;
	if ( null( s))
		printf("NIL");
	else while ( not( null( s))) {
		printf( "%d ", car( s));
		s = cdr( s);
		}
	printf("\n");
}

/* frees the memory used by a list (garbage collection) */
void FreeList( list)
cons_ptr list;
{
/*  if (null( list)) return;
	FreeList( cdr( list));
	free( list);*/
}

