/***********************************************************************/
/*                                                                     */
/*                        ANALOGICAL MAP EXPORT FILE                   */
/*                Copyright (C) 1993 Eric Charles Steinhart            */
/*                            All rights reserved.                     */
/*                                                                     */
/***********************************************************************/

struct map_structure *AllocateMap( void);

int GetMapLength(
	struct map_structure *map);

int get_analogue(
	struct SEMANTIC_NETWORK *S,
	struct map_structure *map,
	int term);

struct map_structure *TransferPairToMap(
	struct map_structure *map,
	int TF,
	int SF);

cons_ptr GetTransferredTopicFrames(
	struct map_structure *map,
	cons_ptr TransferredTopicFrames);

int AllHaveAnalogues(
	struct SEMANTIC_NETWORK *S,
	struct map_structure *map,
	cons_ptr list);


/**************************************************************************/
/*                         Map Building Functions                         */
/**************************************************************************/
void InitializeMap(
	struct map_structure *map);

struct map_structure *MakeMap(
	struct map_structure *map,
	sequence_ptr NodePairs);

struct map_structure *make_map_from_net(
	struct SEMANTIC_NETWORK *S,     /* the semantic network */
	struct map_structure *map,      /* the map */
	cons_ptr target,                /* the target field */
	cons_ptr source);               /* the source field */

struct map_structure *mapping_with_network(
	struct SEMANTIC_NETWORK *S);    /* the semantic network */
