
#define WILD_CARD   -1  /* anything matches the wildcard */
						/* the wildcard is a variable    */

struct Fact {
	int NumSlots;
	int Slots[MAX_SLOTS];
	};

struct RuleInterface {
	int         NumRules;
	struct Fact AntecedentFacts[MAX_RULES];
	int         Rules[MAX_RULES];
	};

int InitializeRuleInterface( S, TheRules)
struct SEMANTIC_NETWORK *S;
struct RuleInterface TheRules;
{
	int node, i, j;
	int TheAntecedent;

	/* clear the RuleInterface structure */
	TheRules->NumRules = 0;
	for (i = 0; i < MAX_RULES; i++) {
		ThisAntecedent = TheRules->AntecedentFacts[i];
		for (j=0; j < MAX_SLOTS; j++) {
			ThisAntecedent->Slots[j] = WILD_CARD;
			}
		TheRules->Rules[i] = NO_FILLER;
		}

	for (node=0; node < S->num_nodes; node++) {
		if (S->node_type[node] == RULE) {

			if (TheRules->NumRules == MAX_RULES) {
				_clearscreen( _GCLEARSCREEN);
				printf("ERROR:Too many rules in rule interface.\n");
				exit( ERROR_VALUE);
				}
			/* add the node to TheRules */
			TheRules->Rules[TheRules->NumRules] = node;
			TheRules->NumRules++;

			TheAntecedent = GetAntecedentOf(S, node);
			/* put the elements of TheAntecedent into the rule list */
			/* in surface position order! (in INFIX order)          */
			}
		}
}


int Match( FirstFact, SecondFact)
struct Fact *FirstFact;
struct Fact *SecondFact;
{
	for (i=0; i < FirstFact->NumSlots; i++) {
		if ((FirstFact->Slots[i] != SecondFact->Slots[i])
			&& (FirstFact->Slots[i] != WILD_CARD)
				&& (SecondFact->Slots[i] != WILD_CARD))
			return( FALSE);
		}
	return( TRUE);
}


/* returns { R in TheRules | Fact matches AntecedentOf(R)} */
cons_ptr GetMatchingRules( S, TheRules, TheFact, MatchingRules)
struct SEMANTIC_NETWORK *S;
struct RuleInterface *TheRules;
struct Fact *TheFact;
cons_ptr MatchingRules;
{
	int i, max;

	/**************************************************************/
	/*  for each fact F in TheRules do {                          */
	/*      if TheFact matches F                                  */
	/*      then add TheFact to MatchingRules;}                   */
	/**************************************************************/

	max = TheRules->NumRules;
	for (i=0; i < max; i++) {
		if (Matches(TheFact, TheRules->AntecedentFacts[i]))
			MatchingRules = cons(TheFact, MatchingRules);
		}

	return( MatchingRules);
}







