void PrintHypothesisNet( S, H)
struct SEMANTIC_NETWORK *S;
struct HYPOTHESIS_NET *H;
{
	cons_ptr x;
	sequence_ptr index;
	int i, j;

	printf("------------- Hypothesis Network ------------------\n");

	/* print H->match_hypos */
	printf("The match hypotheses in the net are: \n");
	index = H->match_hypos;
	i = 0;
	while (not(nullseq( index))) {
		x = carseq( index);
		printf("\t%s = %s\t%f\n",
			S->node_names[first(x)],
			S->node_names[second(x)],
			H->seminput[i++]);
		index = cdrseq(index);
		}
	printf("\n");
	strike_any_key();

	/* print the weight matrix */
	printf("The connection matrix is: \n");
	for (i=0; i < H->num_hypos; i++) {
		for (j=0; j < H->num_hypos; j++) {
		if (H->w[i][j] == 0) printf(".");
		else if (H->w[i][j] == EXCITORY) printf("+");
		else if (H->w[i][j] == INHIBITORY) printf("-");
		else printf("?");
		}
		printf("\n");
		}
}

void PrintHypoNetConn( S, H)
struct SEMANTIC_NETWORK *S;
struct HYPOTHESIS_NET *H;
{
	cons_ptr x,y;
	sequence_ptr index;
	int i, j;

	printf("--------- Hypothesis Network Connections ---------\n");

	/* print H->match_hypos */
	index = H->match_hypos;
	while (not(nullseq( index))) {
		x = carseq( index);
		printf("Match hypothesis (%s = %s) has\n",
			S->node_names[first(x)],
			S->node_names[second(x)]);

		/* print the connections of x */
		/* find the position of x in the match hypotheses */
		i = get_positionseq( x, H->match_hypos) - 1;
		/* for each hypothesis */
		for (j=0; j < H->num_hypos; j++) {
			if (H->w[i][j] == EXCITORY){
			   y = get_nth_seq( H->match_hypos, j);
			   printf("\tEXCITORY with (%s = %s)\n",
				S->node_names[first(y)],
				S->node_names[second(y)]);
			   }
			if (H->w[i][j] == INHIBITORY) {
			   y = get_nth_seq( H->match_hypos, j);
			   printf("\tINHIBITORY with (%s = %s)\n",
				S->node_names[first(y)],
				S->node_names[second(y)]);
			   }
			} /* end for j */

		printf("\n");
		index = cdrseq(index);
		} /* end while not null index */
}
