/***************************************************************************/
/*                                                                         */
/*                              SEMANTIC NETWORK                           */
/*                                                                         */
/***************************************************************************/


/***************************************************************************/
/*                                 DEFINITIONS                             */
/***************************************************************************/
/* Define the maximum number of nodes. */
#define MAX_NODES  400

/* Define the maximum number of connections. */
#define MAX_CONNECTIONS  1500

/* The enumerated types VERB . . . WHOLE and MAX_FUNC_ROLES */
/* and MAX_ROLES are correlated with the role names file <SemRoles.txt>. */
/* <SemRoles.txt> is browsable but not modifiable by the user. */

/* THEMATIC_ROLES is an enumerated type. */
#define VERB            0
#define AGENT           1
#define PATIENT         2
#define RECIPIENT       3
#define SOURCE          4
#define INSTRUMENT      5
#define GOAL            6
#define PATH            7
#define ABOUT           8   /* FIRST_PREPOSITION */
#define ABOVE           9
#define AROUND         10
#define AT             11
#define AWAY           12
#define AWAY_FROM      13
#define BELOW          14
#define BENEATH        15
#define BESIDE         16
#define BETWEEN        17
#define BY             18
#define DOWN           19
#define FOR            20
#define FROM           21
#define IN             22
#define INSIDE         23
#define INSIDE_OF      24
#define NEAR           25
#define OF             26
#define OFF            27
#define ON             28
#define ONTO           29
#define OUT            30
#define OUTSIDE_OF     31
#define OVER           32
#define THROUGH        33
#define THROUGHOUT     34
#define TO             35
#define TOWARD         36
#define UNDER          37
#define UNDERNEATH     38
#define UP             39
#define WITH           40
#define WITHIN         41
#define WITHOUT        42
#define M_VERB         43
#define M_AGENT        44
#define M_PATIENT      45
#define M_RECIPIENT    46
#define M_SOURCE       47
#define M_INSTRUMENT   48
#define M_GOAL         49
#define M_PATH         50   /* MAX_FUNC_ROLES */
#define PART           51
#define WHOLE          52
#define GEN1           53
#define GEN2           54
#define SUBJECT        55
#define PREDICATE      56
#define ANTECEDENT     57
#define CONSEQUENT     58
#define ANDBRANCH      59
#define SUPERTYPE      60
#define SUBTYPE        61
#define ATTRIBUTE      62
#define VALUE          63
#define PROPERTY       64
#define OBJECT         65
#define SUCCESSOR      66
#define PREDECESSOR    67
#define CONTRAST       68   /* FIRST_PARA_ROLE */
#define POSITIVE       69   /* FIRST_PARA_ARG_ROLE */
#define NEGATIVE       70   /* LAST_PARA_ROLE */

/******************************************************************/
/*                                                                */
/* WARNING! WARNING! WARNING! WARNING! WARNING! WARNING! WARNING! */
/*                                                                */
/* The way roles are now structured (t+MOD_ROLE) does not yield   */
/* %t for prepositions!   (ABOVE+MOD_ROLE) == PART                */
/*                                                                */
/* WARNING! WARNING! WARNING! WARNING! WARNING! WARNING! WARNING! */
/******************************************************************/

/* Roles from FIRST_MOD_ROLE to MAX_FUNC_ROLES are modifier roles */
/* If t is a non-mod role, (t+MOD_ROLE) is %t */
/* where %t is the modifier role for t */
/* I.e. %AGENT is the modifier role for AGENT */
#define MOD_ROLES               43
#define FIRST_PREPOSITION        8
/* Roles above MAX_FUNC_ROLES are non-functional roles */
#define MAX_FUNC_ROLES          50
/* Roles from FIRST_PARA_ROLE to LAST_PARA_ROLE are paradigmatic roles */
#define FIRST_PARA_ROLE         68
#define FIRST_PARA_ARG_ROLE     69
#define LAST_PARA_ROLE          70

/* Define maximum number of thematic roles */
#define MAX_ROLES               71

/* SEMANTIC_MODES is an enumerated type */
#define LITERAL         0
#define ANALOGICAL      1
#define MAX_MODES       2


/* GRAMMATICAL_CATEGORIES is an enumerated type. */
#define NOUN            0
#define VERBTYPE        1
#define ADJECTIVE       2
#define ADVERB          3
#define CONTRASTTYPE    4
#define SFRAME          5
#define MFRAME          6
#define PFRAME          7
#define RULE            8
#define CONJUNCTION     9
#define PROPERTYTYPE    10
#define DESCRIPTION     11
#define MAX_CATS        12

#define NET_NIL_CODE -1

/* define a cell for representing a connection */
struct connect_node {
	int col;
	int val;
	struct connect_node *next;
	};
typedef struct connect_node *connect_ptr;


struct SEMANTIC_NETWORK {
	int             num_nodes;
	char            node_names[MAX_NODES][MAX_STRLEN];
	int             num_connections;
	connect_ptr     R[MAX_NODES];  /* a sparse matrix */
	int             role[MAX_CONNECTIONS];
	int             mode[MAX_CONNECTIONS];
	int             surface_pos[MAX_CONNECTIONS];
	int             node_type[MAX_NODES];
	sequence_ptr    fields;
	};

extern char role_names[MAX_ROLES][MAX_STRLEN];

extern char mode_names[MAX_MODES][MAX_STRLEN];

extern char cat_names[MAX_CATS][MAX_STRLEN];

#define GetNumNodes( S)         (S->num_nodes)
#define SetNumNodes( S, n)      (S->num_nodes = n)
#define GetNodeNames(S)         (S->node_names)
#define GetName( S, n)          (S->node_names[n])
#define GetNumConn( S)          (S->num_connections)
#define SetNumConn( S, n)       (S->num_connections = n);
#define GetRole( S, n)          (S->role[n])
#define SetRole( S, n, r)       (S->role[n] = r)
#define GetMode( S, n)          (S->mode[n])
#define SetMode( S, n, m)       (S->mode[n] = m)
#define GetSurfPos( S, n)       (S->surface_pos[n])
#define SetSurfPos( S, n, p)    (S->surface_pos[n] = p)
#define GetType( S, n)          (S->node_type[n])
#define SetType( S, n, t)       (S->node_type[n] = t)
#define GetFields(S)            (S->fields)
#define SetFields( S, n)        (S->fields = n)

struct SEMANTIC_NETWORK *AllocateSemanticNet( void);

int GetConn(
	struct SEMANTIC_NETWORK *S,
	int row,
	int column);


void SetConn(
	struct SEMANTIC_NETWORK *S,
	int row,
	int column,
	int value);

int no_connection(
	struct SEMANTIC_NETWORK *S,
	int x,
	int y,
	int t);

struct SEMANTIC_NETWORK *AddNode(
	struct SEMANTIC_NETWORK *S,
	int NodeType,
	char *NodeName);


struct SEMANTIC_NETWORK *AddOneConnection(
	struct SEMANTIC_NETWORK *S,
	int x,
	int y,
	int t,
	int order);

struct SEMANTIC_NETWORK *AddConnections(
	struct SEMANTIC_NETWORK *S,
	int x,
	int y,
	int t,
	int order,
	int position);

int print_node_names(
	cons_ptr list,
	struct SEMANTIC_NETWORK *S);

int print_node_names_NOCR(
	cons_ptr list,
	struct SEMANTIC_NETWORK *S);

void print_sequence_names(
	sequence_ptr sequence,
	struct SEMANTIC_NETWORK *sem_net);

struct SEMANTIC_NETWORK *set_net_to_nil(
	struct SEMANTIC_NETWORK *S);

int null_net(
	struct SEMANTIC_NETWORK *s);

