/***********************************************************************/
/*                                                                     */
/*                       SEQUENCE PROCESSING FUNCTIONS                 */
/*                Copyright (C) 1992 Eric Charles Steinhart            */
/*                            All rights reserved.                     */
/*                                                                     */
/***********************************************************************/

/* Library of functions for processing sequences of nodes */

#include "stdio.h"
#include "C:\qc25\include\malloc.h"
#include "anadefs.h"

/* sequence functions make use of list functions */
/* since the members of sequences are lists */
#include "list.c"

/* conseq creates and returns a new sequence cell whose car is this_data */
/* and whose cdr is sequence. */
/* space for this new sequence cell is allocated on the heap */
sequence_ptr conseq( this_list, sequence )
cons_ptr this_list;
sequence_ptr sequence;
{
	sequence_ptr s;
	s = (sequence_ptr) malloc( (size_t)sizeof( struct sequence_cell));
	/* set car to this_list */
	s->cell_data = this_list;
	/* set cdr to sequence */
	s->next = sequence;
	return( s );
}

/* nconseq() creates and returns a new sequence */
/* whose car is this_list and whose cdr is nil */
sequence_ptr nconseq( this_list )
cons_ptr this_list;
{
	return( conseq( this_list, NIL));
}

/* test for a null sequence */
int nullseq( sequence )
sequence_ptr sequence;
{
	return( (sequence == NIL) ? TRUE : FALSE);
}

/* retrieve the car of a sequence cell */
cons_ptr carseq( sequence )
sequence_ptr sequence;
{
	return( nullseq( sequence) ? NIL : sequence->cell_data);
}

/* first() is a synonym for car() */
cons_ptr firstseq( sequence )
sequence_ptr sequence;
{
	return( nullseq( sequence) ? NIL : sequence->cell_data);
}

/* retrieve the cdr of a sequence cell */
sequence_ptr cdrseq( sequence )
sequence_ptr sequence;
{
	return( nullseq( sequence) ? NIL : sequence->next);
}

cons_ptr secondseq( sequence)
sequence_ptr sequence;
{
	return( carseq( cdrseq( sequence)));
}

/* returns a pointer to the last element of a sequence */
sequence_ptr lastseq( sequence)
sequence_ptr sequence;
{
	sequence_ptr x;
	x = sequence;
	if (nullseq( sequence))
		return( NIL);
	else while (not( nullseq( x))) {
		if (nullseq(cdrseq(x))) return( x);
		x = cdrseq(x);
		}
}

sequence_ptr appendseq( sequence1, sequence2)
sequence_ptr sequence1;
sequence_ptr sequence2;
{

	sequence_ptr x;

	if (nullseq( sequence1))
		return( sequence2);
	else {
		x = lastseq( sequence1);
		x->next = sequence2;
		return( sequence1);
		}
}

/* check for membership in a sequence */
int is_memberseq( list, sequence )
cons_ptr list;
sequence_ptr sequence;
{
	if ( nullseq( sequence))
		return( FALSE);
	else if ( equal( carseq( sequence), list))
		return( TRUE);
		else return( is_memberseq( list, cdrseq( sequence)));
}

/* return the length of a sequence */
/* length of the null sequence is 0 */
int lengthseq( sequence)
sequence_ptr sequence;
{
	sequence_ptr s;
	int sequence_len;
	s = sequence;
	sequence_len = 0;
	if ( nullseq( s))
		return( 0);
	else while ( not( nullseq( s))) {
		sequence_len++;
		s = cdrseq( s);
		}
	return( sequence_len);
}

/* compute the union of two sequences */
/* the second sequence is modified */
sequence_ptr unionseq( sequence1, sequence2 )
sequence_ptr sequence1;
sequence_ptr sequence2;
{
	sequence_ptr s;
	s = sequence1;
	while ( not( nullseq( s))) {
		if ( not( is_memberseq( carseq( s), sequence2)))
			sequence2 = conseq( carseq( s), sequence2);
		s = cdrseq( s);
		}
	return( sequence2);
}


/* prints the members of a sequence as lists */
void print_sequence( sequence)
sequence_ptr sequence;
{
	sequence_ptr s;
	s = sequence;
	if ( nullseq( s))
		printf("NIL");
	else while ( not( nullseq( s))) {
		print_list( carseq( s));
		s = cdrseq( s);
		}
	printf("\n");
}

int TermInSequence( term, sequence)
int term;
sequence_ptr sequence;
{
	int result;
	cons_ptr list;
	sequence_ptr ptr;

	for (ptr = sequence; not(nullseq(ptr)); ptr = cdrseq(ptr)) {
		list = carseq(ptr);
		if (is_member(term, list)) return(TRUE);
		}
	return( FALSE);
}


int get_positionseq( element, sequence)
cons_ptr element;
sequence_ptr sequence;
{
	int i;
	sequence_ptr x;

	if (nullseq( sequence))
		return( 0);
	else {
		i = 1;
		x = sequence;
		while (not( nullseq(x))) {
/*          printf("Comp (%d,%d) to (%d,%d) in pos %d\n",
			   first(element), second(element),
			   first(carseq(x)), second(carseq(x)), i);*/
			if (equal( carseq( x), element))
				return( i);
			i++;
			x = cdrseq( x);
			}
		return( 0); /* nulled out without finding element */
		}
}

cons_ptr get_nth_seq( seq, n)
sequence_ptr seq;
int n;
{

	sequence_ptr ptr;
	int i;
	cons_ptr elem;

	if (n > lengthseq( seq)) return( NIL);

	i = 0;
	ptr = seq;
	while( not( nullseq( ptr))) {
		elem = carseq( ptr);
		if (i == n) return( elem);
		i++;
		ptr = cdrseq(ptr);
		}

	return(NIL);
}


/* frees the memory used by a list (garbage collection) */
void FreeSequence( sequence)
sequence_ptr sequence;
{
/*  if (nullseq( sequence)) return;
	FreeList( carseq( sequence));
	FreeSequence( cdrseq( sequence));
	free( sequence);*/
}
